/*
 * Decompiled with CFR 0.152.
 */
package panda.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import panda.signer.PublickeyReader;
import panda.signer.Utils;

public class SignChecker {
    private String publickeyPath;

    public final boolean verify(String publickeyPath, String local) {
        this.publickeyPath = publickeyPath;
        boolean filesVerified = false;
        Properties prop = new Properties();
        String propertiesPath = local + File.separator + "sig.properties";
        try (FileInputStream input = new FileInputStream(propertiesPath);){
            prop.load(input);
            String propertySignature = prop.getProperty("Signature");
            ArrayList<File> fileList = new ArrayList<File>();
            Utils.listFiles(local, fileList);
            String md5Strings = "";
            for (File file : fileList) {
                try {
                    md5Strings = md5Strings + Utils.getHashOfFile(file);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            filesVerified = this.verify(md5Strings.getBytes(), propertySignature);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return filesVerified;
    }

    private boolean verify(byte[] data, String signature) {
        boolean filesVerified = false;
        try {
            Signature sign = Signature.getInstance("SHAwithDSA");
            PublickeyReader publicKeyReader = new PublickeyReader();
            PublicKey publicKey = publicKeyReader.get(this.publickeyPath);
            sign.initVerify(publicKey);
            sign.update(data);
            filesVerified = sign.verify(Base64.decodeBase64(signature.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return filesVerified;
    }
}

