/*
 * Decompiled with CFR 0.152.
 */
package panda.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;

public class Utils {
    public static final String ALGORITHM = "DSA";
    public static final String SIGNATURE_ALGORITHM = "SHAwithDSA";

    public static void listFiles(String directoryName, ArrayList<File> fileList) {
        File directory = new File(directoryName);
        File[] fileArray = directory.listFiles();
        if (fileArray.length != 0 || fileArray != null) {
            for (File file : fileArray) {
                if (file.isFile()) {
                    if (!file.getName().startsWith(".") && !file.getName().startsWith("sig.properties")) {
                        fileList.add(file);
                        continue;
                    }
                    if (file.getName().startsWith(".")) {
                        System.out.println("Ignoring " + file.getName());
                        continue;
                    }
                    if (!file.getName().equals("sig.properties")) continue;
                    System.out.println("Ignoring sig.properties");
                    continue;
                }
                if (file.isDirectory() && !file.getName().startsWith(".")) {
                    Utils.listFiles(file.getAbsolutePath(), fileList);
                    continue;
                }
                if (!file.getName().startsWith(".")) continue;
                System.out.println("Ignoring " + file.getName());
            }
        }
    }

    public static final String getHashOfFile(File file) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        FileInputStream fis = new FileInputStream(file);
        String hash = DigestUtils.sha256Hex(fis);
        fis.close();
        return hash;
    }
}

