/*
 * Decompiled with CFR 0.152.
 */
package x2br.app;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import x2br.app.AppLoader;

public class OldAppLoader {
    static final String AppDirName = "MyApp";
    static final String JarName = "MyApp.jar";
    static final String JarURL = "http://your-site.com/jars/MyApp.jar";
    static final String LoaderJarName = "AppLoader.jar";
    static final String MainClass = "whatever.app.App";
    static boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    static boolean isMac = System.getProperty("os.name").indexOf("Mac OS X") >= 0;

    public static void main(String[] args) {
        try {
            OldAppLoader.main1(args);
        }
        catch (Throwable e) {
            OldAppLoader.showMessage("Error in Main", e.toString());
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) throws Exception {
        try {
            OldAppLoader.copyDefaultMainJar();
        }
        catch (Exception e) {
            OldAppLoader.showMessage("Error Copying Main Jar", e.toString());
            e.printStackTrace();
        }
        File jar = OldAppLoader.getAppFile(JarName);
        File updateJar = OldAppLoader.getAppFile("MyApp.jar.update");
        if (updateJar.exists()) {
            OldAppLoader.copyFile(updateJar, jar);
            jar.setLastModified(updateJar.lastModified());
            updateJar.delete();
        }
        if (!jar.exists() || !jar.canRead()) {
            throw new RuntimeException("Main Jar not found!");
        }
        new Thread(() -> OldAppLoader.checkForUpdatesSilent()).start();
        URLClassLoader ucl = new URLClassLoader(new URL[]{jar.toURI().toURL()});
        Class<?> cls = ucl.loadClass(MainClass);
        Method meth = cls.getMethod("main", String[].class);
        meth.invoke(null, new Object[]{args});
        if (cls == Object.class) {
            ucl.close();
        }
    }

    private static void copyDefaultMainJar() throws IOException, ParseException {
        URL url = AppLoader.class.getProtectionDomain().getCodeSource().getLocation();
        String path0 = url.getPath();
        path0 = URLDecoder.decode(path0, "UTF-8");
        String path2 = path0.replace(LoaderJarName, "BuildInfo.txt");
        BufferedReader br = new BufferedReader(new FileReader(path2));
        String text = br.readLine();
        br.close();
        if (text == null || text.length() < 0) {
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy", Locale.US);
        Date date = formatter.parse(text);
        long time = date.getTime();
        String path1 = path0.replace(LoaderJarName, JarName);
        File jar0 = OldAppLoader.getAppFile(JarName);
        File jar1 = new File(path1);
        if (jar0.exists() && jar0.lastModified() >= time) {
            return;
        }
        OldAppLoader.copyFile(jar1, jar0);
        jar0.setLastModified(time);
    }

    private static void checkForUpdatesSilent() {
        try {
            OldAppLoader.checkForUpdates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkForUpdates() throws IOException, MalformedURLException {
        File jarFile = OldAppLoader.getAppFile(JarName);
        URL url = new URL(JarURL);
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        long mod0 = jarFile.lastModified();
        long mod1 = connection.getLastModified();
        if (mod0 >= mod1) {
            System.out.println("No update available at http://your-site.com/jars/MyApp.jar(" + mod0 + '>' + mod1 + ')');
            return;
        }
        System.out.println("Loading update from http://your-site.com/jars/MyApp.jar");
        byte[] bytes = OldAppLoader.getBytes(connection);
        System.out.println("Update loaded");
        File updateFile = OldAppLoader.getAppFile("MyApp.jar.update");
        if (JarURL.endsWith(".pack.gz")) {
            File updatePacked = OldAppLoader.getAppFile("MyApp.jar.pack.gz");
            OldAppLoader.writeBytes(updatePacked, bytes);
            System.out.println("Update saved: " + updatePacked);
            OldAppLoader.unpack(updatePacked, updateFile);
            System.out.println("Update unpacked: " + updateFile);
            updatePacked.delete();
        } else {
            OldAppLoader.writeBytes(updateFile, bytes);
            System.out.println("Update saved: " + updateFile);
        }
        updateFile.setLastModified(mod1);
        String msg = "A new update is available. Restart application to apply";
        SwingUtilities.invokeLater(() -> OldAppLoader.showMessage("New Update Found", msg));
    }

    private static File getAppFile(String aName) {
        return new File(OldAppLoader.getAppDir(), aName);
    }

    private static File getAppDir() {
        return OldAppLoader.getAppDataDir(AppDirName, true);
    }

    static void showMessage(String aTitle, String aMsg) {
        JOptionPane.showMessageDialog(null, aMsg, aTitle, 1);
    }

    public static File copyFile(File aSource, File aDest) throws IOException {
        FileInputStream fis = new FileInputStream(aSource);
        File out = aDest.isDirectory() ? new File(aDest, aSource.getName()) : aDest;
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[8192];
        int i = fis.read(buf);
        while (i != -1) {
            fos.write(buf, 0, i);
            i = fis.read(buf);
        }
        fis.close();
        fos.close();
        return out;
    }

    public static void writeBytes(File aFile, byte[] theBytes) throws IOException {
        if (theBytes == null) {
            aFile.delete();
            return;
        }
        FileOutputStream fileStream = new FileOutputStream(aFile);
        fileStream.write(theBytes);
        fileStream.close();
    }

    public static File unpack(File aFile, File aDestFile) throws IOException {
        File destFile = OldAppLoader.getUnpackDestination(aFile, aDestFile);
        if (destFile.exists() && destFile.lastModified() > aFile.lastModified()) {
            return destFile;
        }
        FileInputStream fileInput = new FileInputStream(aFile);
        GZIPInputStream gzipInput = new GZIPInputStream(fileInput);
        FileOutputStream fileOut = new FileOutputStream(destFile);
        JarOutputStream jarOut = new JarOutputStream(fileOut);
        Pack200.newUnpacker().unpack((InputStream)gzipInput, jarOut);
        fileInput.close();
        gzipInput.close();
        jarOut.close();
        fileOut.close();
        return destFile;
    }

    public static File getUnpackDestination(File aFile, File aDestFile) {
        File destFile = aDestFile;
        if (destFile == null) {
            destFile = new File(aFile.getPath().replace(".pack.gz", ""));
        } else if (destFile.isDirectory()) {
            destFile = new File(destFile, aFile.getName().replace(".pack.gz", ""));
        }
        return destFile;
    }

    public static File getAppDataDir(String aName, boolean doCreate) {
        String dir = System.getProperty("user.home");
        if (isWindows) {
            dir = dir + File.separator + "AppData" + File.separator + "Local";
        } else if (isMac) {
            dir = dir + File.separator + "Library" + File.separator + "Application Support";
        }
        if (aName != null) {
            dir = dir + File.separator + aName;
        }
        File dfile = new File(dir);
        if (doCreate && aName != null) {
            dfile.mkdirs();
        }
        return dfile;
    }

    public static byte[] getBytes(URLConnection aConnection) throws IOException {
        InputStream stream = aConnection.getInputStream();
        byte[] bytes = OldAppLoader.getBytes(stream);
        stream.close();
        return bytes;
    }

    public static byte[] getBytes(InputStream aStream) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        byte[] chunk = new byte[8192];
        int len = aStream.read(chunk, 0, 8192);
        while (len > 0) {
            bs.write(chunk, 0, len);
            len = aStream.read(chunk, 0, 8192);
        }
        return bs.toByteArray();
    }
}

