/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.application;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javafx.scene.control.Alert;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ProgramStarter {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private String path = this.getPath();
    private static final int SUBSTRING_BEGIN_INDEX = 9;
    static final Logger logger = Logger.getLogger(ProgramStarter.class);

    public ProgramStarter() {
        System.out.println("path: " + this.path);
    }

    private String getPath() {
        String current = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + File.separator;
        return current;
    }

    public final void startProgramm() {
        if (ProgramStarter.isWindows()) {
            System.out.println("This is Windows");
            this.startBatch();
        } else if (ProgramStarter.isMac()) {
            System.out.println("This is Mac");
            this.startMacShell();
        } else if (ProgramStarter.isUnix()) {
            System.out.println("This is Unix or Linux");
            this.startShell();
        } else {
            System.out.println("Your OS is not support!");
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("SO n\u00e3o suportado!");
            alert.setHeaderText("Seu sistema operacional n\u00e3o \u00e9 suportado.");
            alert.setContentText("Parece que n\u00e3o suportamos o seu sistema operacional, desculpe por isso. Verifique a p\u00e1gina do AppLauncher no gitlab e deixe um coment\u00e1rio com as seguintes informa\u00e7\u00f5es: OS =" + OS);
            alert.showAndWait();
            logger.error("Confira a \u00faltima p\u00e1gina final do AppLauncher no gitlab e deixe um coment\u00e1rio com a seguinte informa\u00e7\u00e3o: OS=" + OS);
        }
        System.exit(0);
    }

    private void startBatch() {
        try {
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
            String command = "cmd /c start " + this.path + "app\\startW.bat";
            System.out.println("command: " + command);
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
        }
    }

    private void startMacShell() {
        try {
            new File(this.path + "app/mac.sh").setExecutable(true);
            new ProcessBuilder(this.path + "app/startM.sh").start();
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
            logger.error(e);
        }
    }

    private void startShell() {
        try {
            new File(this.path + "app/start.sh").setExecutable(true);
            new ProcessBuilder(this.path + "app/startL.sh").start();
        }
        catch (IOException e) {
            Frame frame = new Frame();
            JOptionPane.showMessageDialog(frame, e.toString(), "Error", 0);
            logger.error(e);
        }
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }
}

