/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.stereo;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.util.stereo.StereoDevice;

public abstract class StereoDeviceFactory {
    private static final String OVRStereoDeviceClazzName = "jogamp.opengl.oculusvr.OVRStereoDeviceFactory";
    private static final String GenericStereoDeviceClazzName = "jogamp.opengl.util.stereo.GenericStereoDeviceFactory";
    private static final String isAvailableMethodName = "isAvailable";

    public static StereoDeviceFactory createDefaultFactory() {
        ClassLoader classLoader = StereoDeviceFactory.class.getClassLoader();
        StereoDeviceFactory stereoDeviceFactory = StereoDeviceFactory.createFactory(classLoader, OVRStereoDeviceClazzName);
        if (null == stereoDeviceFactory) {
            stereoDeviceFactory = StereoDeviceFactory.createFactory(classLoader, GenericStereoDeviceClazzName);
        }
        return stereoDeviceFactory;
    }

    public static StereoDeviceFactory createFactory(DeviceType deviceType) {
        String string;
        switch (deviceType) {
            case Default: {
                return StereoDeviceFactory.createDefaultFactory();
            }
            case Generic: {
                string = GenericStereoDeviceClazzName;
                break;
            }
            case OculusVR: {
                string = OVRStereoDeviceClazzName;
                break;
            }
            default: {
                throw new InternalError("XXX");
            }
        }
        ClassLoader classLoader = StereoDeviceFactory.class.getClassLoader();
        return StereoDeviceFactory.createFactory(classLoader, string);
    }

    public static StereoDeviceFactory createFactory(ClassLoader classLoader, String string) {
        block3: {
            try {
                if (((Boolean)ReflectionUtil.callStaticMethod(string, isAvailableMethodName, null, null, classLoader)).booleanValue()) {
                    return (StereoDeviceFactory)ReflectionUtil.createInstance(string, classLoader);
                }
            }
            catch (Throwable throwable) {
                if (!StereoDevice.DEBUG) break block3;
                System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public abstract StereoDevice createDevice(int var1, StereoDevice.Config var2, boolean var3);

    public static enum DeviceType {
        Default,
        Generic,
        OculusVR;

    }
}

