/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop;

import fi.iki.elonen.util.ServerRunner;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import mp.mprj.webdesktop.Version;
import mprj.webdesktop.AboutDialog;
import mprj.webdesktop.resources.Resources;
import org.panda_lang.pandomium.Pandomium;
import org.panda_lang.pandomium.settings.PandomiumSettings;
import org.panda_lang.pandomium.settings.PandomiumSettingsBuilder;
import org.panda_lang.pandomium.util.os.PandomiumOSType;
import org.panda_lang.pandomium.wrapper.PandomiumBrowser;
import org.panda_lang.pandomium.wrapper.PandomiumClient;
import x2br.security.driver.http.server.TokenDriverHttpServer;

public class Desktop {
    String line1;
    String[] fonts = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    private final String urlL = "http://10.0.5.54:9000/#?defaultRole=Eleitor";
    private final String urlD = "https://d-sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final String urlH = "https://h-sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final String urlQ = "https://q-sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final String urlT = "https://t-sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final String urlC = "https://c-sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final String urlP = "https://sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor";
    private final boolean isProd = true;
    private final String loginType = "&loginType=T";
    private String url = "https://sev.mprj.mp.br/sistema/sev/#?defaultRole=Eleitor&loginType=T";
    private ExecutorService executorService1;
    private ExecutorService executorService2;
    private JFrame frame;
    private Process process;
    private String ua;
    private static String nativesDir;
    private Component currentBrowser = null;
    PandomiumSettings settings;
    Pandomium pandomium;
    PandomiumClient client;
    PandomiumBrowser browser;

    public static void main(String[] args) throws Exception {
        System.out.println("args:" + args.length + "  =>" + args);
        if (args.length == 2 && args[0].equalsIgnoreCase("-nativesDir") && args[1].length() > 3) {
            new Desktop(args[1]).preInit();
        } else {
            new Desktop("natives").preInit();
        }
    }

    public Desktop(String nativesDir) {
        Desktop.nativesDir = nativesDir;
        System.out.println("Natives directory:" + nativesDir);
    }

    private void restart() {
        this.frame.getContentPane().removeAll();
        this.initAndDisplayUI();
    }

    public void preInit() {
        this.init();
    }

    private void init() {
        this.executorService1 = Executors.newSingleThreadExecutor();
        this.executorService1.execute(new Runnable(){

            @Override
            public void run() {
                ServerRunner.run(TokenDriverHttpServer.class);
            }
        });
        this.executorService1.shutdown();
        this.settings = Desktop.getDefaultSettings();
        this.settings.getCefSettings().user_agent = this.getUserAgent();
        this.settings.getCefSettings().ignore_certificate_errors = true;
        this.pandomium = new Pandomium(this.settings);
        this.pandomium.initialize();
        this.frame = new JFrame();
        this.frame.setTitle("MPRJ - Sistema Eletr\u00f4nico de Vota\u00e7\u00e3o - CEDULA ELEITORAL");
        this.frame.setSize(1380, 760);
        this.frame.setLocationRelativeTo(null);
        this.frame.setIconImage(Resources.getIcon("icone-sevapp-desktop_32X32.png").getImage());
        this.initAndDisplayUI();
    }

    private void initAndDisplayUI() {
        final JToolBar toolbar = new JToolBar("Applications");
        JButton btnHome = new JButton(Resources.getIcon("home.png"));
        btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this.restart();
            }
        });
        JButton btnReload = new JButton(Resources.getIcon("refresh.png"));
        btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this.browser.getCefBrowser().reloadIgnoreCache();
            }
        });
        JButton btnAbout = new JButton(Resources.getIcon("about.png"));
        btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame parentFrame = (Frame)SwingUtilities.getWindowAncestor(toolbar);
                AboutDialog aboutDialog = new AboutDialog(parentFrame);
                aboutDialog.setVisible(true);
            }
        });
        toolbar.add(btnHome);
        toolbar.add(btnReload);
        toolbar.add(btnAbout);
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add((Component)toolbar, "North");
        this.frame.setDefaultCloseOperation(3);
        this.client = this.pandomium.createClient();
        this.browser = this.client.loadURL(this.url);
        this.currentBrowser = this.browser.toAWTComponent();
        this.frame.getContentPane().add(this.currentBrowser, "Center");
        this.frame.setSize(1300, 900);
        this.frame.setLocationRelativeTo(null);
        this.frame.setIconImage(Resources.getIcon("icone-sevapp-desktop_32X32.png").getImage());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("Closed");
                Desktop.this.clearCache();
                e.getWindow().dispose();
            }
        });
        this.frame.setVisible(true);
    }

    private void loadURL() {
        String urlx = this.url + "&loginType=T";
        this.browser.getCefBrowser().loadURL(urlx);
    }

    private synchronized void clearCache() {
        System.out.println("Limpando o cache...");
    }

    private String getUserAgent() {
        StringBuilder buf = new StringBuilder();
        buf.append("Mozilla/5.0 (").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch")).append("; ").append("uname:").append(System.getProperty("user.name")).append(")").append("  AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36 MPRJ-Web-Desktop/").append(Version.getVersion());
        return buf.toString();
    }

    public static String getSHA256Hash(String texto) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] msg = texto.getBytes();
            md.reset();
            md.update(msg);
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("==>" + ex);
            return texto;
        }
    }

    public static PandomiumSettingsBuilder getDefaultSettingsBuilder() {
        return PandomiumSettings.builder().dependencyURL(PandomiumOSType.OS_WINDOWS, "https://pandomium.panda-lang.org/download/natives/67.0/win64-natives.tar.xz").dependencyURL(PandomiumOSType.OS_MAC, "https://pandomium.panda-lang.org/download/natives/67.0/mac64-natives.tar.xz").dependencyURL(PandomiumOSType.OS_LINUX, "https://pandomium.panda-lang.org/download/natives/67.0/linux64-natives.tar.xz").nativeDirectory(nativesDir).loadAsync(true);
    }

    public static PandomiumSettings getDefaultSettings() {
        return Desktop.getDefaultSettingsBuilder().build();
    }
}

