/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;

class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler {
    public CefRenderer renderer_;
    public GLCanvas canvas_;
    public long window_handle_ = 0L;
    public Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    public Point screenPoint_ = new Point(0, 0);
    public boolean isTransparent_;

    CefBrowserOsr(CefClient cefClient, String string, boolean bl, CefRequestContext cefRequestContext) {
        this(cefClient, string, bl, cefRequestContext, null, null);
    }

    public CefBrowserOsr(CefClient cefClient, String string, boolean bl, CefRequestContext cefRequestContext, CefBrowserOsr cefBrowserOsr, Point point) {
        super(cefClient, string, cefRequestContext, cefBrowserOsr, point);
        this.isTransparent_ = bl;
        this.renderer_ = new CefRenderer(bl);
        this.createGLCanvas();
    }

    @Override
    public Component getUIComponent() {
        return this.canvas_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    public CefBrowser_N createDevToolsBrowser(CefClient cefClient, String string, CefRequestContext cefRequestContext, CefBrowser_N cefBrowser_N, Point point) {
        return new CefBrowserOsr(cefClient, string, this.isTransparent_, cefRequestContext, this, point);
    }

    public synchronized long getWindowHandle() {
        NativeSurface nativeSurface;
        if (this.window_handle_ == 0L && (nativeSurface = this.canvas_.getNativeSurface()) != null) {
            nativeSurface.lockSurface();
            this.window_handle_ = this.getWindowHandle(nativeSurface.getSurfaceHandle());
            nativeSurface.unlockSurface();
            assert (this.window_handle_ != 0L);
        }
        return this.window_handle_;
    }

    public void createGLCanvas() {
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.canvas_ = new GLCanvas(gLCapabilities){

            @Override
            public void paint(Graphics graphics) {
                if (CefBrowserOsr.this.getParentBrowser() != null) {
                    CefBrowserOsr.this.createDevTools(CefBrowserOsr.this.getParentBrowser(), CefBrowserOsr.this.getClient(), CefBrowserOsr.this.getWindowHandle(), CefBrowserOsr.this.isTransparent_, null, CefBrowserOsr.this.getInspectAt());
                } else {
                    CefBrowserOsr.this.createBrowser(CefBrowserOsr.this.getClient(), CefBrowserOsr.this.getWindowHandle(), CefBrowserOsr.this.getUrl(), CefBrowserOsr.this.isTransparent_, null, CefBrowserOsr.this.getRequestContext());
                }
                super.paint(graphics);
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                CefBrowserOsr.this.browser_rect_.setBounds(n, n2, n3, n4);
                CefBrowserOsr.this.screenPoint_ = CefBrowserOsr.this.canvas_.getLocationOnScreen();
                CefBrowserOsr.this.wasResized(n3, n4);
            }

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.initialize(gLAutoDrawable.getGL().getGL2());
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.cleanup(gLAutoDrawable.getGL().getGL2());
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                CefBrowserOsr.this.renderer_.render(gLAutoDrawable.getGL().getGL2());
            }
        });
        this.canvas_.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }
        });
        this.canvas_.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                CefBrowserOsr.this.sendMouseEvent(mouseEvent);
            }
        });
        this.canvas_.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                CefBrowserOsr.this.sendMouseWheelEvent(mouseWheelEvent);
            }
        });
        this.canvas_.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CefBrowserOsr.this.sendKeyEvent(keyEvent);
            }
        });
        this.canvas_.setFocusable(true);
        this.canvas_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CefBrowserOsr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserOsr.this.setFocus(true);
            }
        });
    }

    @Override
    public Rectangle getViewRect(CefBrowser cefBrowser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser cefBrowser, Point point) {
        Point point2 = new Point(this.screenPoint_);
        point2.translate(point.x, point.y);
        return point2;
    }

    @Override
    public void onPopupShow(CefBrowser cefBrowser, boolean bl) {
        if (!bl) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser cefBrowser, Rectangle rectangle) {
        this.renderer_.onPopupSize(rectangle);
    }

    @Override
    public void onPaint(CefBrowser cefBrowser, boolean bl, Rectangle[] rectangleArray, ByteBuffer byteBuffer, int n, int n2) {
        this.canvas_.getContext().makeCurrent();
        this.renderer_.onPaint(this.canvas_.getGL().getGL2(), bl, rectangleArray, byteBuffer, n, n2);
        this.canvas_.getContext().release();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.display();
            }
        });
    }

    @Override
    public void onCursorChange(CefBrowser cefBrowser, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.setCursor(new Cursor(n));
            }
        });
    }

    @Override
    public boolean startDragging(CefBrowser cefBrowser, CefDragData cefDragData, int n, int n2, int n3) {
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser cefBrowser, int n) {
    }
}

