/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

class CefRenderer {
    public boolean transparent_;
    public GL2 initialized_context_ = null;
    public int[] texture_id_ = new int[1];
    public int view_width_ = 0;
    public int view_height_ = 0;
    public float spin_x_ = 0.0f;
    public float spin_y_ = 0.0f;
    public Rectangle popup_rect_ = new Rectangle(0, 0, 0, 0);
    public Rectangle original_popup_rect_ = new Rectangle(0, 0, 0, 0);
    public boolean use_draw_pixels_ = false;

    public CefRenderer(boolean bl) {
        this.transparent_ = bl;
    }

    public boolean isTransparent() {
        return this.transparent_;
    }

    public void initialize(GL2 gL2) {
        if (this.initialized_context_ == gL2) {
            return;
        }
        this.initialized_context_ = gL2;
        if (!gL2.getContext().isHardwareRasterizer()) {
            System.out.println("opengl rendering may be slow as hardware rendering isn't available");
            this.use_draw_pixels_ = true;
            return;
        }
        gL2.glHint(3155, 4354);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glPixelStorei(3317, 1);
        gL2.glGenTextures(1, this.texture_id_, 0);
        assert (this.texture_id_[0] != 0);
        gL2.glBindTexture(3553, this.texture_id_[0]);
        gL2.glTexParameteri(3553, 10241, 9728);
        gL2.glTexParameteri(3553, 10240, 9728);
        gL2.glTexEnvf(8960, 8704, 8448.0f);
    }

    public void cleanup(GL2 gL2) {
        if (this.texture_id_[0] != 0) {
            gL2.glDeleteTextures(1, this.texture_id_, 0);
        }
    }

    public void render(GL2 gL2) {
        if (this.use_draw_pixels_ || this.view_width_ == 0 || this.view_height_ == 0) {
            return;
        }
        assert (this.initialized_context_ != null);
        float[] fArray = new float[]{0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f};
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray);
        gL2.glClear(0x4000 | 0x100);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glViewport(0, 0, this.view_width_, this.view_height_);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glPushAttrib(1048575);
        gL2.glBegin(7);
        gL2.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        gL2.glVertex2f(-1.0f, -1.0f);
        gL2.glVertex2f(1.0f, -1.0f);
        gL2.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        gL2.glVertex2f(1.0f, 1.0f);
        gL2.glVertex2f(-1.0f, 1.0f);
        gL2.glEnd();
        gL2.glPopAttrib();
        if (this.spin_x_ != 0.0f) {
            gL2.glRotatef(-this.spin_x_, 1.0f, 0.0f, 0.0f);
        }
        if (this.spin_y_ != 0.0f) {
            gL2.glRotatef(-this.spin_y_, 0.0f, 1.0f, 0.0f);
        }
        if (this.transparent_) {
            gL2.glBlendFunc(1, 771);
            gL2.glEnable(3042);
        }
        gL2.glEnable(3553);
        assert (this.texture_id_[0] != 0);
        gL2.glBindTexture(3553, this.texture_id_[0]);
        gL2.glInterleavedArrays(10791, 0, floatBuffer);
        gL2.glDrawArrays(7, 0, 4);
        gL2.glDisable(3553);
        if (this.transparent_) {
            gL2.glDisable(3042);
        }
    }

    public void onPopupSize(Rectangle rectangle) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        this.original_popup_rect_ = rectangle;
        this.popup_rect_ = this.getPopupRectInWebView(this.original_popup_rect_);
    }

    public Rectangle getPopupRect() {
        return (Rectangle)this.popup_rect_.clone();
    }

    public Rectangle getPopupRectInWebView(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle;
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        if (rectangle2.x + rectangle2.width > this.view_width_) {
            rectangle2.x = this.view_width_ - rectangle2.width;
        }
        if (rectangle2.y + rectangle2.height > this.view_height_) {
            rectangle2.y = this.view_height_ - rectangle2.height;
        }
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        return rectangle2;
    }

    public void clearPopupRects() {
        this.popup_rect_.setBounds(0, 0, 0, 0);
        this.original_popup_rect_.setBounds(0, 0, 0, 0);
    }

    public void onPaint(GL2 gL2, boolean bl, Rectangle[] rectangleArray, ByteBuffer byteBuffer, int n, int n2) {
        this.initialize(gL2);
        if (this.use_draw_pixels_) {
            gL2.glRasterPos2f(-1.0f, 1.0f);
            gL2.glPixelZoom(1.0f, -1.0f);
            gL2.glDrawPixels(n, n2, 32993, 5121, byteBuffer);
            return;
        }
        if (this.transparent_) {
            gL2.glEnable(3042);
        }
        gL2.glEnable(3553);
        assert (this.texture_id_[0] != 0);
        gL2.glBindTexture(3553, this.texture_id_[0]);
        if (!bl) {
            int n3 = this.view_width_;
            int n4 = this.view_height_;
            this.view_width_ = n;
            this.view_height_ = n2;
            gL2.glPixelStorei(3314, this.view_width_);
            if (n3 != this.view_width_ || n4 != this.view_height_) {
                gL2.glPixelStorei(3316, 0);
                gL2.glPixelStorei(3315, 0);
                gL2.glTexImage2D(3553, 0, 6408, this.view_width_, this.view_height_, 0, 32993, 33639, byteBuffer);
            } else {
                for (int i = 0; i < rectangleArray.length; ++i) {
                    Rectangle rectangle = rectangleArray[i];
                    gL2.glPixelStorei(3316, rectangle.x);
                    gL2.glPixelStorei(3315, rectangle.y);
                    gL2.glTexSubImage2D(3553, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 32993, 33639, byteBuffer);
                }
            }
        } else if (bl && this.popup_rect_.width > 0 && this.popup_rect_.height > 0) {
            int n5 = 0;
            int n6 = this.popup_rect_.x;
            int n7 = 0;
            int n8 = this.popup_rect_.y;
            int n9 = n;
            int n10 = n2;
            if (n6 < 0) {
                n5 = -n6;
                n6 = 0;
            }
            if (n8 < 0) {
                n7 = -n8;
                n8 = 0;
            }
            if (n6 + n9 > this.view_width_) {
                n9 -= n6 + n9 - this.view_width_;
            }
            if (n8 + n10 > this.view_height_) {
                n10 -= n8 + n10 - this.view_height_;
            }
            gL2.glPixelStorei(3314, n);
            gL2.glPixelStorei(3316, n5);
            gL2.glPixelStorei(3315, n7);
            gL2.glTexSubImage2D(3553, 0, n6, n8, n9, n10, 32993, 33639, byteBuffer);
        }
        gL2.glDisable(3553);
        if (this.transparent_) {
            gL2.glDisable(3042);
        }
    }

    public void setSpin(float f, float f2) {
        this.spin_x_ = f;
        this.spin_y_ = f2;
    }

    public void incrementSpin(float f, float f2) {
        this.spin_x_ -= f;
        this.spin_y_ -= f2;
    }
}

