/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda;

import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.Panda;
import org.panda_lang.panda.framework.PandaFrameworkException;
import org.panda_lang.panda.framework.design.architecture.PandaApplication;
import org.panda_lang.panda.framework.design.architecture.PandaEnvironment;
import org.panda_lang.panda.framework.design.interpreter.PandaInterpreter;
import org.panda_lang.panda.framework.design.interpreter.source.SourceProvider;
import org.panda_lang.panda.framework.design.interpreter.source.SourceSet;
import org.panda_lang.panda.framework.language.interpreter.source.providers.DirectorySourceProvider;
import org.panda_lang.panda.framework.language.interpreter.source.providers.FileSourceProvider;
import org.panda_lang.panda.utilities.commons.io.FileUtils;

public class PandaLoader {
    private final Panda panda;

    public PandaLoader(Panda panda) {
        this.panda = panda;
    }

    public PandaApplication loadFiles(String ... paths) {
        return this.load(new FileSourceProvider(FileUtils.toFiles(paths)));
    }

    public PandaApplication loadFiles(File ... files) {
        return this.load(new FileSourceProvider(files));
    }

    public PandaApplication loadDirectory(File directory) {
        return this.load(new DirectorySourceProvider(directory));
    }

    @Nullable
    public PandaApplication load(SourceProvider provider) {
        SourceSet sourceSet = provider.toSourceSet();
        if (sourceSet.isEmpty()) {
            throw new PandaFrameworkException("Sources are not provided");
        }
        PandaEnvironment environment = new PandaEnvironment(this.panda);
        environment.initialize();
        PandaInterpreter interpreter = environment.getInterpreter();
        return interpreter.interpret(sourceSet);
    }
}

