/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import org.panda_lang.panda.Panda;
import org.panda_lang.panda.PandaFactory;
import org.panda_lang.panda.bootstrap.GenerationInitializer;
import org.panda_lang.panda.framework.design.architecture.prototype.registry.ClassPrototypeModel;
import org.panda_lang.panda.framework.design.interpreter.PandaLanguage;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.utilities.commons.LoggingUtils;

public class PandaBootstrap {
    protected Syntax syntax;
    protected PipelineRegistry registry;
    protected Collection<Collection<Class<? extends ClassPrototypeModel>>> modelsCollection = new ArrayList<Collection<Class<? extends ClassPrototypeModel>>>();
    protected GenerationInitializer generationInitializer;

    public PandaBootstrap() {
        LoggingUtils.skipJansi();
    }

    public PandaBootstrap syntax(Syntax syntax) {
        this.syntax = syntax;
        return this;
    }

    public PandaBootstrap mapModels(Collection<Class<? extends ClassPrototypeModel>> models) {
        this.modelsCollection.add(models);
        return this;
    }

    public PandaBootstrap addGenerationHandler(GenerationInitializer initializer) {
        this.generationInitializer = initializer;
        return this;
    }

    public Panda get() {
        PandaFactory factory = new PandaFactory();
        Panda panda = factory.createPanda();
        PandaLanguage elements = panda.getPandaLanguage();
        elements.setSyntax(this.syntax);
        elements.setMappings(this.modelsCollection);
        return panda;
    }
}

