/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.dynamic.block.conditional;

import org.panda_lang.panda.framework.design.architecture.dynamic.Block;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.architecture.dynamic.AbstractBlock;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class ConditionalBlock
extends AbstractBlock {
    private final Expression condition;
    private Block elseBlock;

    public ConditionalBlock(Expression condition) {
        if (!condition.getReturnType().isClassOf("Boolean")) {
            throw new PandaParserException("Condition has to return boolean");
        }
        this.condition = condition;
    }

    @Override
    public void execute(ExecutableBranch branch) {
        Value value = this.condition.getExpressionValue(branch);
        boolean flag = (Boolean)value.getValue();
        if (flag) {
            branch.call(super.getStatementCells());
            return;
        }
        if (this.elseBlock != null) {
            branch.call(this.elseBlock);
        }
    }

    public void setElseBlock(Block elseBlock) {
        this.elseBlock = elseBlock;
    }
}

