/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.field.FieldVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PandaPrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorManager;
import org.panda_lang.panda.framework.language.architecture.value.PandaStaticValue;
import org.panda_lang.panda.framework.language.architecture.value.PandaValue;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;
import org.panda_lang.panda.framework.language.runtime.expression.PandaExpression;

public class ClassPrototypeFieldGenerator {
    private final ClassPrototypeGenerator generator;
    @Nullable
    private final ModulePath modulePath;
    private final ClassPrototype prototype;
    private final Field field;

    public ClassPrototypeFieldGenerator(ClassPrototypeGenerator generator, @Nullable ModulePath modulePath, ClassPrototype prototype, Field field) {
        this.generator = generator;
        this.modulePath = modulePath;
        this.prototype = prototype;
        this.field = field;
    }

    public PrototypeField generate() {
        ClassPrototype returnType = this.generator.computeIfAbsent(this.modulePath, this.field.getType());
        PandaPrototypeField prototypeField = PandaPrototypeField.builder().fieldIndex(this.prototype.getFields().getAmountOfFields()).type(returnType).name(this.field.getName()).visibility(FieldVisibility.PUBLIC).isStatic(Modifier.isStatic(this.field.getModifiers())).mutable(true).nullable(true).build();
        this.field.setAccessible(true);
        PandaExpression fieldExpression = new PandaExpression(returnType, (expression, branch) -> {
            long start = System.nanoTime();
            Object instance = branch != null ? branch.getInstance().getValue() : null;
            try {
                Object value = this.field.get(instance);
                PandaValue pandaValue = new PandaValue(returnType, value);
                return pandaValue;
            }
            catch (IllegalAccessException e) {
                throw new PandaRuntimeException(e);
            }
            finally {
                ClassPrototypeGeneratorManager.reflectionsTime += System.nanoTime() - start;
            }
        });
        prototypeField.setDefaultValue(fieldExpression);
        prototypeField.setStaticValue(PandaStaticValue.of(fieldExpression, null));
        return prototypeField;
    }
}

