/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.generator;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorManager;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorUtils;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethod;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethod;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.architecture.value.PandaValue;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;

public class ClassPrototypeMethodGenerator {
    private final ClassPrototypeGenerator generator;
    private final ModulePath modulePath;
    private final ClassPrototype prototype;
    private final Method method;

    public ClassPrototypeMethodGenerator(ClassPrototypeGenerator generator, ModulePath modulePath, ClassPrototype prototype, Method method) {
        if (method == null) {
            throw new InvalidParameterException("Method cannot be null");
        }
        this.generator = generator;
        this.modulePath = modulePath;
        this.prototype = prototype;
        this.method = method;
    }

    public PrototypeMethod generate() {
        ClassPrototype returnType = this.generator.computeIfAbsent(this.modulePath, this.method.getReturnType());
        ClassPrototype[] parametersTypes = ClassPrototypeGeneratorUtils.toTypes(this.modulePath, this.method.getParameterTypes());
        if (returnType == null) {
            throw new PandaRuntimeException("Cannot generate method for 'null' return type");
        }
        boolean isVoid = returnType.getClassName().equals("void");
        this.method.setAccessible(true);
        MethodCallback<Object> methodBody = (branch, instance, parameters) -> {
            long start = System.nanoTime();
            try {
                int amountOfArgs = parameters.length;
                int parameterCount = this.method.getParameterCount();
                Object varargs = null;
                if (amountOfArgs != parameterCount) {
                    if (parameterCount < 1) {
                        throw new PandaRuntimeException("Too many arguments");
                    }
                    Class<?> last = this.method.getParameterTypes()[parameterCount - 1];
                    String lastName = last.getName();
                    Class<?> rootLast = Class.forName(lastName.substring(2, lastName.length() - 1));
                    if (amountOfArgs + 1 != parameterCount || !last.isArray()) {
                        throw new PandaRuntimeException("Cannot invoke mapped mapped method (args.length != parameters.length)");
                    }
                    varargs = Array.newInstance(rootLast, 0);
                    ++amountOfArgs;
                }
                Object[] args = new Object[amountOfArgs];
                for (int i = 0; i < parameters.length; ++i) {
                    Value parameter = parameters[i];
                    if (parameter == null) continue;
                    args[i] = parameter.getValue();
                }
                if (varargs != null) {
                    args[amountOfArgs - 1] = varargs;
                }
                Object returnValue = this.method.invoke(instance, args);
                if (isVoid) {
                    return;
                }
                PandaValue value = new PandaValue(returnType, returnValue);
                branch.setReturnValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ClassPrototypeGeneratorManager.reflectionsTime += System.nanoTime() - start;
            }
        };
        return PandaMethod.builder().prototype(this.prototype).visibility(MethodVisibility.PUBLIC).isStatic(Modifier.isStatic(this.method.getModifiers())).returnType(returnType).methodName(this.method.getName()).methodBody(methodBody).parameterTypes(parametersTypes).build();
    }
}

