/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.method;

import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodVisibility;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethodBuilder;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethod;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.language.runtime.ExecutableBranch;

public class PandaMethod
implements PrototypeMethod {
    private final ClassPrototype prototype;
    private final String methodName;
    private final ClassPrototype[] parameterTypes;
    private final ClassPrototype returnType;
    private final MethodCallback methodBody;
    private MethodVisibility visibility;
    private final boolean isStatic;
    private final boolean catchAllParameters;

    protected PandaMethod(PandaMethodBuilder builder) {
        this.prototype = builder.prototype;
        this.methodName = builder.methodName;
        this.returnType = builder.returnType;
        this.methodBody = builder.methodBody;
        this.isStatic = builder.isStatic;
        this.visibility = builder.visibility;
        this.catchAllParameters = builder.catchAllParameters;
        this.parameterTypes = builder.parameterTypes != null ? builder.parameterTypes : new ClassPrototype[]{};
    }

    @Override
    public void invoke(ExecutableBranch branch, Object instance, Value ... parameters) {
        this.methodBody.invoke(branch, instance, parameters);
    }

    @Override
    public boolean isCatchingAllParameters() {
        return this.catchAllParameters;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public MethodVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public ClassPrototype getReturnType() {
        return this.returnType;
    }

    @Override
    public ClassPrototype[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public ClassPrototype getClassPrototype() {
        return this.prototype;
    }

    public static PandaMethodBuilder builder() {
        return new PandaMethodBuilder();
    }
}

