/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.registry;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.panda_lang.panda.framework.PandaFramework;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodVisibility;
import org.panda_lang.panda.util.PandaUtils;

public interface ClassPrototypeModel {
    public static Collection<Class<? extends ClassPrototypeModel>> of(String moduleName) {
        PandaFramework.getLogger().debug("Looking for subtypes of ClassPrototypeModel");
        ArrayList<Class<? extends ClassPrototypeModel>> classes = new ArrayList<Class<? extends ClassPrototypeModel>>();
        Set<Class<ClassPrototypeModel>> models = PandaUtils.DEFAULT_PANDA_SCANNER.createSelector().selectSubtypesOf(ClassPrototypeModel.class);
        for (Class<ClassPrototypeModel> clazz : models) {
            ModuleDeclaration module = clazz.getAnnotation(ModuleDeclaration.class);
            if (!module.value().equals(moduleName)) continue;
            classes.add(clazz);
        }
        PandaFramework.getLogger().debug("Subtypes: " + classes.size());
        return classes;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TypeDeclaration {
        public String value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface MethodDeclaration {
        public MethodVisibility visibility() default MethodVisibility.PUBLIC;

        public boolean isStatic() default false;

        public String returnType() default "void";

        public boolean catchAllParameters() default false;
    }

    @Target(value={ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstructorDeclaration {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClassDeclaration {
        public String value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ModuleDeclaration {
        public String value();
    }
}

