/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype.registry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.module.PrimitivePrototypeLiquid;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.PandaClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGenerator;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorUtils;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PandaMethod;
import org.panda_lang.panda.framework.design.architecture.prototype.registry.ClassPrototypeModel;
import org.panda_lang.panda.framework.design.architecture.prototype.registry.ClassPrototypeModelMethodCallback;
import org.panda_lang.panda.framework.design.architecture.prototype.registry.ClassPrototypeModelMethodRegister;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class ClassPrototypeModelLoader {
    private static final AtomicInteger idAssigner = new AtomicInteger();
    private final ModulePath modulePath;

    public ClassPrototypeModelLoader(ModulePath modulePath) {
        this.modulePath = modulePath;
    }

    public void load(Collection<Class<? extends ClassPrototypeModel>> models) {
        try {
            this.loadModels(models);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadModels(Collection<Class<? extends ClassPrototypeModel>> models) throws Exception {
        ArrayList<ClassPrototypeModelMethodRegister> methodRegisters = new ArrayList<ClassPrototypeModelMethodRegister>();
        ClassPrototypeGenerator generator = new ClassPrototypeGenerator();
        ClassPool pool = ClassPool.getDefault();
        CtClass objectCtClass = pool.getCtClass(Object.class.getName());
        CtClass methodCallbackCtClass = pool.get(ClassPrototypeModelMethodCallback.class.getName());
        CtClass executableBranchCtClass = pool.get(ExecutableBranch.class.getName());
        CtClass valueArrayCtClass = pool.get(Value[].class.getName());
        CtClass valueCtClass = pool.get(Value.class.getName());
        CtClass[] implementationTypes = new CtClass[]{executableBranchCtClass, objectCtClass, valueArrayCtClass};
        for (Class<? extends ClassPrototypeModel> modelClass : models) {
            ClassPrototypeModel.ModuleDeclaration moduleDeclaration = modelClass.getAnnotation(ClassPrototypeModel.ModuleDeclaration.class);
            ClassPrototypeModel.ClassDeclaration classDeclaration = modelClass.getAnnotation(ClassPrototypeModel.ClassDeclaration.class);
            String moduleName = moduleDeclaration.value();
            Module module = this.modulePath.get(moduleName);
            if (module != null && module.get(classDeclaration.value()) != null) continue;
            PandaClassPrototype prototype = new PandaClassPrototype(classDeclaration.value(), modelClass, new String[0]);
            if (module == null) {
                module = this.modulePath.create(moduleName);
            }
            module.add(prototype);
            for (Method method : modelClass.getMethods()) {
                String methodCallbackClassName;
                CtClass generatedMethodCallbackClass;
                ClassPrototypeModel.MethodDeclaration methodDeclaration = method.getAnnotation(ClassPrototypeModel.MethodDeclaration.class);
                if (methodDeclaration == null || (generatedMethodCallbackClass = pool.getOrNull(methodCallbackClassName = modelClass.getSimpleName() + StringUtils.capitalize(method.getName()) + "MethodCallback" + idAssigner.incrementAndGet())) != null) continue;
                generatedMethodCallbackClass = pool.makeClass(methodCallbackClassName);
                generatedMethodCallbackClass.setSuperclass(methodCallbackCtClass);
                CtMethod callbackImplementation = new CtMethod(CtClass.voidType, "invoke", implementationTypes, generatedMethodCallbackClass);
                boolean array = method.getParameters()[method.getParameters().length - 1].getType().isArray();
                StringBuilder values = new StringBuilder();
                int valuesCount = 0;
                for (int i = 2; i < method.getParameters().length; ++i) {
                    values.append(",");
                    if (array && i == method.getParameterCount() - 1) {
                        values.append("values");
                        break;
                    }
                    values.append("(").append(Value.class.getName()).append(")");
                    values.append("$3[").append(i - 2).append("]");
                    ++valuesCount;
                }
                String instanceType = method.getParameters()[1].getType().getName();
                StringBuilder bodyBuilder = new StringBuilder("{");
                if (array) {
                    bodyBuilder.append(String.format("%s[] values = new %s[$3.length - %d];", valueCtClass.getName(), valueCtClass.getName(), valuesCount));
                    bodyBuilder.append("for (int i = 0; i < values.length; i++) {");
                    bodyBuilder.append(String.format("values[i] = $3[%d + i];", valuesCount));
                    bodyBuilder.append("}");
                }
                if (methodDeclaration.isStatic()) {
                    bodyBuilder.append(String.format("%s.%s($1, (%s) null %s);", modelClass.getName(), method.getName(), instanceType, values.toString()));
                } else {
                    bodyBuilder.append(String.format("%s typedInstance = (%s) $2;", modelClass.getName(), modelClass.getName()));
                    bodyBuilder.append(String.format("typedInstance.%s($1, (%s) $2 %s);", method.getName(), instanceType, values.toString()));
                }
                bodyBuilder.append("}");
                String body = bodyBuilder.toString();
                callbackImplementation.setBody(body);
                generatedMethodCallbackClass.addMethod(callbackImplementation);
                Class methodCallbackClass = generatedMethodCallbackClass.toClass();
                MethodCallback methodCallback = (MethodCallback)methodCallbackClass.newInstance();
                ClassPrototype[] parameterTypes = ClassPrototypeGeneratorUtils.toTypes(this.modulePath, method.getParameterTypes());
                methodRegisters.add(() -> {
                    PandaMethod pandaMethod = PandaMethod.builder().methodName(method.getName()).prototype(prototype).returnType(PrimitivePrototypeLiquid.VOID).isStatic(methodDeclaration.isStatic()).visibility(methodDeclaration.visibility()).methodBody(methodCallback).parameterTypes(parameterTypes).catchAllParameters(methodDeclaration.catchAllParameters()).build();
                    prototype.getMethods().registerMethod(pandaMethod);
                });
            }
        }
        for (ClassPrototypeModelMethodRegister methodRegister : methodRegisters) {
            methodRegister.register();
        }
    }
}

