/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.interpreter;

import org.panda_lang.panda.framework.design.architecture.Environment;
import org.panda_lang.panda.framework.design.architecture.PandaApplication;
import org.panda_lang.panda.framework.design.interpreter.Interpreter;
import org.panda_lang.panda.framework.design.interpreter.PandaInterpreterBuilder;
import org.panda_lang.panda.framework.design.interpreter.PandaLanguage;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessage;
import org.panda_lang.panda.framework.design.interpreter.source.SourceSet;
import org.panda_lang.panda.framework.language.interpreter.PandaInterpretation;
import org.panda_lang.panda.framework.language.parser.implementation.ApplicationParser;

public class PandaInterpreter
implements Interpreter {
    private final Environment environment;
    private final PandaLanguage language;

    protected PandaInterpreter(PandaInterpreterBuilder builder) {
        this.environment = builder.environment;
        this.language = builder.elements;
    }

    @Override
    public PandaApplication interpret(SourceSet sources) {
        PandaInterpretation interpretation = new PandaInterpretation(this.environment, this, this.language);
        ApplicationParser parser = new ApplicationParser(interpretation);
        PandaApplication application = parser.parse(sources);
        if (!interpretation.isHealthy()) {
            interpretation.getMessenger().sendMessage(MessengerMessage.Level.FAILURE, "Interpretation failed, cannot parse specified sources");
            return null;
        }
        return application;
    }

    public static PandaInterpreterBuilder builder() {
        return new PandaInterpreterBuilder();
    }
}

