/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.interpreter.parser.pipeline;

import java.util.Set;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.PandaPipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserHandler;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.language.interpreter.parser.pipeline.PandaParserRepresentation;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerProcess;

public class ParserRegistrationLoader {
    public PipelineRegistry load(AnnotationsScannerProcess scannerProcess) {
        PandaPipelineRegistry registry = new PandaPipelineRegistry();
        try {
            this.loadPipelines(registry, scannerProcess);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return registry;
    }

    public void loadPipelines(PandaPipelineRegistry registry, AnnotationsScannerProcess scannerProcess) throws Exception {
        Set<Class<?>> annotated = scannerProcess.createSelector().selectTypesAnnotatedWith(ParserRegistration.class);
        for (Class<?> clazz : annotated) {
            ParserRegistration parserRegistration = clazz.getAnnotation(ParserRegistration.class);
            UnifiedParser parser = parserRegistration.parserClass().newInstance();
            ParserHandler handler = parserRegistration.handlerClass().newInstance();
            PandaParserRepresentation representation = new PandaParserRepresentation(parser, handler, parserRegistration.priority());
            for (String target : parserRegistration.target()) {
                ParserPipeline pipeline = registry.getOrCreate(target);
                pipeline.registerParserRepresentation(representation);
            }
        }
    }
}

