/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.interpreter.token;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenizedSource;

public interface TokenizedSource {
    public TokenizedSource subSource(int var1, int var2);

    public List<TokenRepresentation> getTokensRepresentations();

    public TokenRepresentation[] toArray();

    default public TokenizedSource selectLine(int line) {
        ArrayList<TokenRepresentation> selected = new ArrayList<TokenRepresentation>();
        for (TokenRepresentation tokenRepresentation : this.getTokensRepresentations()) {
            if (tokenRepresentation.getLine() < line) continue;
            if (tokenRepresentation.getLine() > line) break;
            selected.add(tokenRepresentation);
        }
        return new PandaTokenizedSource(selected);
    }

    default public TokenizedSource addToken(TokenRepresentation tokenRepresentation) {
        this.getTokensRepresentations().add(tokenRepresentation);
        return this;
    }

    default public int size() {
        return this.getTokensRepresentations().size();
    }

    @Nullable
    default public TokenRepresentation getFirst() {
        return this.size() > 0 ? this.get(0) : null;
    }

    @Nullable
    default public TokenRepresentation getLast() {
        return this.getLast(0);
    }

    @Nullable
    default public TokenRepresentation getLast(int i) {
        int index = this.size() - i - 1;
        return index > -1 ? this.get(index) : null;
    }

    @Nullable
    default public String getTokenValue(int id) {
        Token token = this.getToken(id);
        if (token == null) {
            return null;
        }
        return token.getTokenValue();
    }

    @Nullable
    default public Token getToken(int id) {
        TokenRepresentation tokenRepresentation = this.get(id);
        if (tokenRepresentation == null) {
            return null;
        }
        return tokenRepresentation.getToken();
    }

    @Nullable
    default public TokenRepresentation get(int id) {
        if (id >= this.size() || id < 0) {
            return null;
        }
        return this.getTokensRepresentations().get(id);
    }

    default public String asString() {
        StringBuilder node = new StringBuilder();
        for (TokenRepresentation representation : this.getTokensRepresentations()) {
            Token token = representation.getToken();
            node.append(token.getTokenValue());
        }
        return node.toString();
    }
}

