/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.architecture.module;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;

public class PandaModule
implements Module {
    private final String name;
    private final Collection<ClassPrototype> prototypes;

    public PandaModule(String name) {
        this.name = name;
        this.prototypes = new ArrayList<ClassPrototype>();
    }

    @Override
    public ClassPrototype add(ClassPrototype prototype) {
        this.prototypes.add(prototype);
        return prototype;
    }

    @Override
    @Nullable
    public ClassPrototype get(String className) {
        for (ClassPrototype prototype : this.prototypes) {
            if (!prototype.isClassOf(className)) continue;
            return prototype;
        }
        return null;
    }

    @Override
    public int getAmountOfPrototypes() {
        return this.prototypes.size();
    }

    public Collection<ClassPrototype> getPrototypes() {
        return this.prototypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName() + "[" + this.prototypes.size() + "]";
    }
}

