/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.lexer;

import java.util.Collection;
import java.util.Stack;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexer;
import org.panda_lang.panda.framework.language.interpreter.token.PandaToken;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.sequence.Sequence;

public class PandaLexerSequencer {
    private final PandaLexer lexer;
    private final Collection<Sequence> sequences;
    private final Stack<Sequence> sequenceStack;

    public PandaLexerSequencer(PandaLexer lexer, Collection<Sequence> sequences) {
        this.lexer = lexer;
        this.sequences = sequences;
        this.sequenceStack = new Stack();
    }

    public boolean checkBefore(StringBuilder tokenBuilder, char c) {
        if (this.sequenceStack.size() > 0) {
            Sequence sequence;
            String tokenPreview = this.lexer.getTokenBuilder().append(c).toString();
            if (!tokenPreview.endsWith((sequence = this.sequenceStack.peek()).getSequenceEnd())) {
                return true;
            }
            int startIndex = sequence.getSequenceStart().length();
            int endIndex = tokenPreview.length() - sequence.getSequenceEnd().length();
            String sequenceValue = tokenPreview.substring(startIndex, endIndex);
            PandaToken token = new PandaToken(sequence.getType(), sequence.getName(), sequenceValue);
            this.lexer.getTokenizedLine().add(token);
            tokenBuilder.setLength(0);
            this.sequenceStack.pop();
            return true;
        }
        return false;
    }

    public boolean checkAfter(StringBuilder tokenBuilder) {
        String tokenPreview = tokenBuilder.toString();
        for (Sequence sequence : this.sequences) {
            if (!tokenPreview.startsWith(sequence.getSequenceStart())) continue;
            this.sequenceStack.push(sequence);
            return true;
        }
        return false;
    }
}

