/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.messenger;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.PandaFrameworkException;
import org.panda_lang.panda.framework.design.interpreter.messenger.Messenger;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessage;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessageTranslator;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerOutputListener;
import org.panda_lang.panda.framework.language.interpreter.messenger.PandaMessengerMessage;
import org.panda_lang.panda.utilities.commons.collection.ReverseIterator;

public class PandaMessenger
implements Messenger {
    private final List<MessengerMessageTranslator> translators = new ArrayList<MessengerMessageTranslator>();
    private MessengerOutputListener outputListener;

    @Override
    public void send(Object message) {
        MessengerMessageTranslator translator = null;
        for (MessengerMessageTranslator messageTranslator : new ReverseIterator<MessengerMessageTranslator>(this.translators)) {
            if (!messageTranslator.getType().isAssignableFrom(message.getClass()) || translator != null && messageTranslator.getType().isAssignableFrom(translator.getType())) continue;
            translator = messageTranslator;
        }
        if (translator == null) {
            if (message instanceof Exception) {
                ((Exception)message).printStackTrace();
            }
            throw new PandaFrameworkException("Cannot translate a message - translator for " + message.getClass() + " not found");
        }
        translator.handle(this, message);
    }

    @Override
    public void sendMessage(MessengerMessage.Level level, String message) {
        PandaMessengerMessage generatedMessage = new PandaMessengerMessage(level, message);
        this.sendMessage(generatedMessage);
    }

    @Override
    public void sendMessage(MessengerMessage message) {
        this.outputListener.onMessage(message);
    }

    public void addMessageTranslator(MessengerMessageTranslator translator) {
        this.translators.add(translator);
    }

    @Override
    public void setOutputListener(MessengerOutputListener listener) {
        this.outputListener = listener;
    }
}

