/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.messenger.translators.exception;

import org.panda_lang.panda.framework.design.interpreter.Interpretation;
import org.panda_lang.panda.framework.design.interpreter.messenger.Messenger;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessage;
import org.panda_lang.panda.framework.design.interpreter.messenger.MessengerMessageTranslator;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.interpreter.messenger.PandaMessengerMessage;
import org.panda_lang.panda.framework.language.interpreter.messenger.defaults.DefaultFailureTemplateBuilder;
import org.panda_lang.panda.framework.language.interpreter.messenger.defaults.DefaultMessageFormatter;
import org.panda_lang.panda.framework.language.interpreter.messenger.translators.exception.EmptyPandaExceptionFailure;
import org.panda_lang.panda.utilities.commons.redact.MessageFormatter;

public class ExceptionTranslator
implements MessengerMessageTranslator<Throwable> {
    private final Interpretation interpretation;
    private String location;
    private SourceStream source;

    public ExceptionTranslator(Interpretation interpretation) {
        this.interpretation = interpretation;
    }

    @Override
    public void handle(Messenger messenger, Throwable element) {
        this.interpretation.getFailures().add(new EmptyPandaExceptionFailure());
        MessageFormatter formatter = DefaultMessageFormatter.getFormatter().register("{{message}}", () -> element.getMessage() != null ? element.getMessage() : element.getClass().getSimpleName()).register("{{location}}", () -> this.location != null ? this.location : "?").register("{{line}}", () -> this.source != null && this.source.getCurrentLine() > -1 ? Integer.valueOf(this.source.getCurrentLine() + 1) : "?").register("{{details}}", () -> {
            StringBuilder message = new StringBuilder();
            for (StackTraceElement stackTraceElement : element.getStackTrace()) {
                message.append(stackTraceElement);
                message.append(System.lineSeparator());
            }
            return DefaultFailureTemplateBuilder.indentation(message.toString());
        });
        DefaultFailureTemplateBuilder templateBuilder = new DefaultFailureTemplateBuilder().includeCause().includeDetails(element.getStackTrace()).includeEnvironment().includeEnd();
        PandaMessengerMessage message = new PandaMessengerMessage(MessengerMessage.Level.FAILURE, templateBuilder.getAsLines(formatter, "InterpreterFailure"));
        messenger.sendMessage(message);
        this.location = null;
        this.source = null;
    }

    public ExceptionTranslator updateLocation(String location) {
        this.location = location;
        return this;
    }

    public ExceptionTranslator updateSource(SourceStream source) {
        this.source = source;
        return this;
    }

    @Override
    public Class<Throwable> getType() {
        return Throwable.class;
    }
}

