/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.parser.defaults;

import org.panda_lang.panda.framework.design.interpreter.Interpretation;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGeneration;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserFailure;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;

public class OverallParser
implements Parser {
    private final Interpretation interpretation;
    private final ParserPipeline pipeline;
    private final SourceStream stream;
    private final CasualParserGeneration generation;

    public OverallParser(ParserData data) {
        this.interpretation = data.getComponent(UniversalComponents.INTERPRETATION);
        this.pipeline = data.getComponent(UniversalComponents.PIPELINE).getPipeline("overall");
        this.generation = data.getComponent(UniversalComponents.GENERATION);
        this.stream = data.getComponent(UniversalComponents.SOURCE_STREAM);
    }

    public void parseNext(ParserData data) {
        if (!this.interpretation.isHealthy() || !this.hasNext()) {
            return;
        }
        UnifiedParser parser = this.pipeline.handle(this.stream);
        if (parser == null) {
            throw new PandaParserFailure("Unrecognized syntax", data);
        }
        int sourceLength = this.stream.getUnreadLength();
        parser.parse(data);
        this.generation.executeImmediately(data);
        if (sourceLength == this.stream.getUnreadLength()) {
            throw new PandaParserException(parser.getClass().getSimpleName() + " did nothing with source at line " + TokenUtils.getLine(this.stream.toTokenizedSource()));
        }
    }

    public boolean hasNext() {
        return this.stream.hasUnreadSource();
    }
}

