/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractorSource;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractorSourceUtils;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;

public class AbyssExtractor {
    private final AbyssPattern pattern;
    private final List<TokenizedSource> gaps;

    public AbyssExtractor(AbyssPattern pattern) {
        this.pattern = pattern;
        this.gaps = new ArrayList<TokenizedSource>();
    }

    @Nullable
    public List<TokenizedSource> extract(TokenReader tokenReader) {
        int i;
        this.gaps.clear();
        AbyssPatternUnit[] units = this.pattern.getUnits();
        TokenizedSource tokenizedSource = tokenReader.getTokenizedSource();
        AbyssExtractorSource source = new AbyssExtractorSource(tokenizedSource);
        int hardTypedUnits = AbyssExtractorSourceUtils.countHardTypedUnits(units);
        int[] positions = new int[hardTypedUnits];
        int[] indexes = new int[hardTypedUnits];
        boolean simpleAbyss = false;
        int j = 0;
        for (i = 0; i < units.length; ++i) {
            AbyssPatternUnit unit = units[i];
            if (unit.isOptional()) continue;
            if (unit.isAbyss()) {
                if (!unit.isSimpleAbyss()) continue;
                simpleAbyss = true;
                continue;
            }
            int lastIndexOfUnit = !this.pattern.hasLastIndexAlgorithmEnabled() || simpleAbyss && TokenUtils.equals(unit, this.pattern.getFissureToken()) ? AbyssExtractorSourceUtils.indexOf(source, unit, positions[j], this.pattern.getMaxNestingLevel(), simpleAbyss ? this.pattern.getFissureToken() : null) : AbyssExtractorSourceUtils.lastIndexOf(source, unit, positions[j], this.pattern.getMaxNestingLevel(), simpleAbyss ? this.pattern.getFissureToken() : null);
            if (lastIndexOfUnit == -1) {
                return null;
            }
            int index = j++;
            indexes[index] = i;
            positions[index] = lastIndexOfUnit;
            simpleAbyss = false;
        }
        int previousIndex = -1;
        for (i = 0; i < positions.length; ++i) {
            int index = positions[i];
            if (index <= previousIndex) {
                return null;
            }
            previousIndex = index;
        }
        for (i = 0; i < positions.length; ++i) {
            AbyssPatternUnit unit;
            tokenReader.synchronize();
            int currentIndex = indexes[i];
            int previousIndex2 = currentIndex - 1 < 0 ? 0 : currentIndex - 1;
            int indexOfUnit = positions[i] - 1;
            if (currentIndex > -1 && currentIndex < units.length && !(unit = units[previousIndex2]).isAbyss()) {
                AbyssPatternUnit currentUnit = units[currentIndex];
                TokenRepresentation sourceToken = tokenReader.read();
                if (TokenUtils.equals(sourceToken, (Token)currentUnit) || unit.isOptional()) continue;
                return null;
            }
            PandaTokenizedSource gap = new PandaTokenizedSource();
            for (TokenRepresentation representation : tokenReader) {
                int index = tokenReader.getIndex();
                if (index >= indexOfUnit) break;
                tokenReader.read();
                gap.addToken(representation);
            }
            tokenReader.read();
            this.gaps.add(gap);
        }
        if (this.pattern.endsWithGap()) {
            TokenizedSource lastGap = indexes.length > 0 ? tokenizedSource.subSource(positions[positions.length - 1] + 1, tokenizedSource.size()) : tokenizedSource.subSource(0, tokenizedSource.size());
            this.gaps.add(lastGap);
        }
        return this.gaps;
    }
}

