/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils;

import java.util.Collection;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaToken;

public class AbyssPatternCompiler {
    private final AbyssPatternBuilder builder;
    private final Syntax syntax;

    public AbyssPatternCompiler(AbyssPatternBuilder builder, Syntax syntax) {
        this.builder = builder;
        this.syntax = syntax;
    }

    public void compile(String expression) {
        String[] fragments;
        for (String fragment : fragments = expression.split(" ")) {
            Token token;
            boolean optional;
            if (fragment.equals("+**")) {
                this.builder.simpleHollow();
                continue;
            }
            if (fragment.equals("+*")) {
                this.builder.hollow();
                continue;
            }
            boolean bl = optional = fragment.startsWith("[") && fragment.endsWith("]");
            if (optional) {
                fragment = fragment.substring(1, fragment.length() - 1);
            }
            if ((token = this.getToken(fragment, this.syntax.getSeparators(), this.syntax.getOperators(), this.syntax.getKeywords(), this.syntax.getLiterals())) == null) {
                token = new PandaToken(TokenType.UNKNOWN, fragment);
            }
            this.builder.unit(token, optional);
        }
    }

    @SafeVarargs
    protected final Token getToken(String fragment, Collection<? extends Token> ... tokensCollections) {
        for (Collection<? extends Token> tokensCollection : tokensCollections) {
            for (Token token : tokensCollection) {
                if (!fragment.equals(token.getTokenValue())) continue;
                return token;
            }
        }
        return null;
    }
}

