/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.LexicalPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternElement;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.LexicalExtractor;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.LexicalExtractorResult;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.LexicalExtractorWorker;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.processed.WildcardProcessor;

public class LexicalPattern<T> {
    private final LexicalPatternElement pattern;
    @Nullable
    private WildcardProcessor<T> processor;

    public LexicalPattern(LexicalPatternElement elements, @Nullable WildcardProcessor<T> processor) {
        this.pattern = elements;
        this.processor = processor;
    }

    public LexicalExtractorResult<T> extract(LexicalExtractor<T> extractor, String phrase) {
        return extractor.extract(phrase);
    }

    public LexicalExtractorResult<T> extract(String phrase) {
        return this.extract(new DefaultLexicalExtractor(this), phrase);
    }

    public LexicalPattern<T> setWildcardProcessor(WildcardProcessor<T> processor) {
        this.processor = processor;
        return this;
    }

    public boolean hasWildcardProcessor() {
        return this.processor != null;
    }

    @Nullable
    public WildcardProcessor<T> getWildcardProcessor() {
        return this.processor;
    }

    public LexicalPatternElement getModel() {
        return this.pattern;
    }

    public static <T> LexicalPatternBuilder<T> builder() {
        return new LexicalPatternBuilder();
    }

    private static class DefaultLexicalExtractor<T>
    implements LexicalExtractor<T> {
        private final LexicalPattern<T> pattern;

        public DefaultLexicalExtractor(LexicalPattern<T> pattern) {
            this.pattern = pattern;
        }

        @Override
        public LexicalExtractorResult<T> extract(String phrase) {
            return new LexicalExtractorWorker(null).extract(this.pattern.getModel(), phrase);
        }
    }
}

