/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.DefaultLexicalPatternElement;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternElement;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternUnit;

public class LexicalPatternNode
extends DefaultLexicalPatternElement {
    private final List<LexicalPatternElement> elements;
    private final boolean variant;

    public LexicalPatternNode(List<LexicalPatternElement> elements, boolean variant) {
        this.elements = elements;
        this.variant = variant;
    }

    public LexicalPatternNode(List<LexicalPatternElement> elements) {
        this(elements, false);
    }

    public LexicalPatternNode(boolean variant) {
        this(new ArrayList<LexicalPatternElement>(), variant);
    }

    public LexicalPatternNode() {
        this(new ArrayList<LexicalPatternElement>());
    }

    public int countUnits() {
        int i = 0;
        for (LexicalPatternElement element : this.elements) {
            i += element.isUnit() ? 1 : 0;
        }
        return i;
    }

    public List<LexicalPatternUnit> selectUnits(boolean all) {
        ArrayList<LexicalPatternUnit> units = new ArrayList<LexicalPatternUnit>();
        for (LexicalPatternElement element : this.elements) {
            if (!element.isUnit() || !all && element.isOptional()) continue;
            units.add(element.toUnit());
        }
        return units;
    }

    public void add(LexicalPatternElement element) {
        this.elements.add(element);
    }

    public void addAll(List<LexicalPatternElement> elements) {
        this.elements.addAll(elements);
    }

    @Override
    public boolean isVariant() {
        return this.variant;
    }

    public List<LexicalPatternElement> getElements() {
        return this.elements;
    }
}

