/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.panda_lang.panda.framework.PandaFrameworkException;
import org.panda_lang.panda.utilities.commons.io.IOUtils;

public class PandaURLSource {
    private final URL location;

    private PandaURLSource(URL location) {
        this.location = location;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContent() {
        try (InputStream inputStream = this.location.openStream();){
            String string = IOUtils.convertStreamToString(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new PandaFrameworkException(e);
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public static PandaURLSource fromPath(String path) {
        return PandaURLSource.fromFile(new File(path));
    }

    public static PandaURLSource fromFile(File file) {
        try {
            return PandaURLSource.fromUrl(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new PandaFrameworkException(e);
        }
    }

    public static PandaURLSource fromUrl(URL url) {
        return new PandaURLSource(url);
    }
}

