/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.source.providers;

import java.io.File;
import java.util.Iterator;
import org.panda_lang.panda.framework.PandaFrameworkException;
import org.panda_lang.panda.framework.design.interpreter.source.Source;
import org.panda_lang.panda.framework.language.interpreter.source.PandaSource;
import org.panda_lang.panda.framework.language.interpreter.source.PandaURLSource;

class FileToSourceIterator
implements Iterator<Source> {
    private final Iterator<File> iterator;

    public FileToSourceIterator(Iterator<File> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Source next() {
        File next = this.iterator.next();
        if (!next.exists()) {
            throw new PandaFrameworkException("File '" + next.getName() + "' doesn't exist.");
        }
        if (next.isDirectory()) {
            throw new PandaFrameworkException("File '" + next.getName() + "' ia a directory.");
        }
        return new PandaSource(PandaURLSource.fromFile(next));
    }
}

