/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.DefaultCharacters;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.keyword.Keyword;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.keyword.Keywords;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.literal.Literal;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.literal.Literals;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.operator.Operator;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.operator.Operators;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separator;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separators;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.sequence.Sequence;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.sequence.Sequences;

public class PandaSyntax
implements Syntax {
    private static final PandaSyntax INSTANCE = new PandaSyntax();
    private final List<Keyword> keywords = new ArrayList<Keyword>();
    private final List<Literal> literals = new ArrayList<Literal>();
    private final List<Separator> separators = new ArrayList<Separator>();
    private final List<Operator> operators = new ArrayList<Operator>();
    private final List<Sequence> sequences = new ArrayList<Sequence>();
    private char[] specialCharacters = DefaultCharacters.getSpecialCharacters();

    private PandaSyntax() {
        this.initialize();
    }

    private void initialize() {
        Collections.addAll(this.keywords, Keywords.values());
        Collections.addAll(this.literals, Literals.values());
        Collections.addAll(this.separators, Separators.values());
        Collections.addAll(this.operators, Operators.values());
        Collections.addAll(this.sequences, Sequences.values());
        Comparator tokenComparator = (x, y) -> Integer.compare(y.getTokenValue().length(), x.getTokenValue().length());
        this.keywords.sort(tokenComparator);
        this.literals.sort(tokenComparator);
        this.separators.sort(tokenComparator);
        this.operators.sort(tokenComparator);
        this.sequences.sort(tokenComparator);
    }

    public void setSpecialCharacters(char[] specialCharacters) {
        this.specialCharacters = specialCharacters;
    }

    @Override
    public char[] getSpecialCharacters() {
        return this.specialCharacters;
    }

    @Override
    public List<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public List<Operator> getOperators() {
        return this.operators;
    }

    @Override
    public List<Separator> getSeparators() {
        return this.separators;
    }

    @Override
    public List<Literal> getLiterals() {
        return this.literals;
    }

    @Override
    public List<Keyword> getKeywords() {
        return this.keywords;
    }

    public static PandaSyntax getInstance() {
        return INSTANCE;
    }
}

