/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.defaults.separator;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separator;

public class Separators {
    public static final Separator SEMICOLON = new Separator(";");
    public static final Separator COMMA = new Separator(",");
    public static final Separator PERIOD = new Separator(".");
    public static final Separator LEFT_PARENTHESIS_DELIMITER = new Separator("(");
    public static final Separator RIGHT_PARENTHESIS_DELIMITER = new Separator(")");
    public static final Separator LEFT_BRACE_DELIMITER = new Separator("{");
    public static final Separator RIGHT_BRACE_DELIMITER = new Separator("}");
    public static final Separator LEFT_BRACKET_DELIMITER = new Separator("[");
    public static final Separator RIGHT_BRACKET_DELIMITER = new Separator("]");
    private static final Separator[] VALUES = new Separator[9];

    @Nullable
    public static Separator valueOf(Token token) {
        for (Separator separator : Separators.values()) {
            if (!separator.getTokenValue().equals(token.getTokenValue())) continue;
            return separator;
        }
        return null;
    }

    @Nullable
    public static Separator valueOf(String str) {
        for (Separator separator : Separators.values()) {
            if (!separator.getTokenValue().equals(str)) continue;
            return separator;
        }
        return null;
    }

    public static Separator[] values() {
        return VALUES;
    }

    static {
        Separators.VALUES[0] = SEMICOLON;
        Separators.VALUES[1] = COMMA;
        Separators.VALUES[2] = PERIOD;
        Separators.VALUES[3] = LEFT_PARENTHESIS_DELIMITER;
        Separators.VALUES[4] = RIGHT_PARENTHESIS_DELIMITER;
        Separators.VALUES[5] = LEFT_BRACE_DELIMITER;
        Separators.VALUES[6] = RIGHT_BRACE_DELIMITER;
        Separators.VALUES[7] = LEFT_BRACKET_DELIMITER;
        Separators.VALUES[8] = RIGHT_BRACKET_DELIMITER;
        LEFT_BRACE_DELIMITER.setOpposite(RIGHT_BRACE_DELIMITER);
        LEFT_BRACKET_DELIMITER.setOpposite(RIGHT_BRACKET_DELIMITER);
        LEFT_PARENTHESIS_DELIMITER.setOpposite(RIGHT_PARENTHESIS_DELIMITER);
    }
}

