/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.defaults.sequence;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.sequence.Sequence;

public class Sequences {
    public static final Sequence STRING = new Sequence("String", '\"');
    public static final Sequence RAW_STRING = new Sequence("String", "'");
    public static final Sequence LINE_ORIENTED_COMMENT = new Sequence("Comment", "//", System.lineSeparator());
    public static final Sequence BLOCK_ORIENTED_COMMENT = new Sequence("Comment", "/*", "*/");
    public static final Sequence DOCUMENTATION_ORIENTED_COMMENT = new Sequence("Documentation", "/**", "*/");
    private static final Sequence[] VALUES = new Sequence[5];

    public static Sequence[] values() {
        return VALUES;
    }

    @Nullable
    public static Sequence valueOf(Token token) {
        if (token.getType() != TokenType.SEQUENCE) {
            return null;
        }
        String value = token.getTokenValue();
        for (Sequence sequence : Sequences.values()) {
            if (!sequence.getName().equals(token.getName()) || !sequence.getSequenceStart().equals(value) && !sequence.getSequenceEnd().equals(value)) continue;
            return sequence;
        }
        return null;
    }

    static {
        Sequences.VALUES[0] = STRING;
        Sequences.VALUES[1] = RAW_STRING;
        Sequences.VALUES[2] = LINE_ORIENTED_COMMENT;
        Sequences.VALUES[3] = BLOCK_ORIENTED_COMMENT;
        Sequences.VALUES[4] = DOCUMENTATION_ORIENTED_COMMENT;
    }
}

