/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.distributor;

import org.jetbrains.annotations.NotNull;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReaderIterator;
import org.panda_lang.panda.utilities.commons.arrays.ArrayDistributor;

public class PandaTokenReader
implements TokenReader {
    private final TokenizedSource tokenizedSource;
    private ArrayDistributor<TokenRepresentation> representationsDistributor;
    private PandaTokenReaderIterator iterator;

    public PandaTokenReader(TokenReader tokenReader) {
        this(tokenReader.getTokenizedSource());
        this.setIndex(tokenReader.getIndex());
    }

    public PandaTokenReader(TokenizedSource tokenizedSource) {
        this.tokenizedSource = tokenizedSource;
        this.representationsDistributor = new ArrayDistributor<TokenRepresentation>(tokenizedSource.toArray());
        this.iterator = new PandaTokenReaderIterator(this);
    }

    @Override
    public TokenRepresentation read() {
        return this.representationsDistributor.next();
    }

    @Override
    @NotNull
    public PandaTokenReaderIterator iterator() {
        return this.iterator;
    }

    @Override
    public void setIndex(int index) {
        this.representationsDistributor.setIndex(index);
        this.synchronize();
    }

    @Override
    public int getIndex() {
        return this.representationsDistributor.getIndex();
    }

    @Override
    public TokenizedSource getTokenizedSource() {
        return this.tokenizedSource;
    }
}

