/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation;

import org.panda_lang.panda.framework.PandaFramework;
import org.panda_lang.panda.framework.design.architecture.Environment;
import org.panda_lang.panda.framework.design.architecture.PandaApplication;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.prototype.generator.ClassPrototypeGeneratorManager;
import org.panda_lang.panda.framework.design.interpreter.Interpretation;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.source.Source;
import org.panda_lang.panda.framework.design.interpreter.source.SourceSet;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.Language;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexer;
import org.panda_lang.panda.framework.language.interpreter.messenger.translators.exception.ExceptionTranslator;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserData;
import org.panda_lang.panda.framework.language.interpreter.parser.defaults.OverallParser;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.PandaCasualParserGeneration;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.parser.implementation.general.comment.CommentAssistant;
import org.panda_lang.panda.utilities.commons.BenchmarkUtils;
import org.panda_lang.panda.utilities.commons.objects.TimeUtils;

public class ApplicationParser
implements Parser {
    private final Interpretation interpretation;

    public ApplicationParser(Interpretation interpretation) {
        this.interpretation = interpretation;
    }

    public PandaApplication parse(SourceSet sourceSet) {
        PandaApplication application = new PandaApplication();
        Environment environment = this.interpretation.getEnvironment();
        ModulePath modulePath = environment.getModulePath();
        Module defaultModule = modulePath.get((String)null);
        Language elements = this.interpretation.getLanguage();
        PipelineRegistry pipelineRegistry = elements.getParserPipelineRegistry();
        PandaCasualParserGeneration generation = new PandaCasualParserGeneration();
        PandaParserData baseData = new PandaParserData();
        baseData.setComponent(UniversalComponents.INTERPRETATION, this.interpretation);
        baseData.setComponent(UniversalComponents.PIPELINE, pipelineRegistry);
        baseData.setComponent(UniversalComponents.GENERATION, generation);
        baseData.setComponent(PandaComponents.MODULE_REGISTRY, modulePath);
        ExceptionTranslator exceptionTranslator = new ExceptionTranslator(this.interpretation);
        this.interpretation.getMessenger().addMessageTranslator(exceptionTranslator);
        for (Source source : sourceSet.getSources()) {
            PandaScript pandaScript = new PandaScript(source.getTitle());
            exceptionTranslator.updateLocation(source.getTitle());
            this.interpretation.execute(() -> {
                pandaScript.getModuleLoader().include(defaultModule);
                PandaLexer lexer = new PandaLexer(elements.getSyntax(), source);
                TokenizedSource tokenizedSource = CommentAssistant.uncomment(lexer.convert());
                PandaSourceStream sourceStream = new PandaSourceStream(tokenizedSource);
                exceptionTranslator.updateSource(sourceStream);
                ParserData delegatedData = baseData.fork();
                delegatedData.setComponent(UniversalComponents.SOURCE, tokenizedSource);
                delegatedData.setComponent(UniversalComponents.SOURCE_STREAM, sourceStream);
                delegatedData.setComponent(UniversalComponents.SCRIPT, pandaScript);
                delegatedData.setComponent(PandaComponents.PANDA_SCRIPT, pandaScript);
                OverallParser overallParser = new OverallParser(delegatedData);
                application.addScript(pandaScript);
                while (this.interpretation.isHealthy() && overallParser.hasNext()) {
                    BenchmarkUtils.execute("OverallParser#parseNext", () -> this.interpretation.execute(() -> overallParser.parseNext(delegatedData)));
                }
            });
            PandaFramework.getLogger().debug("Total Native Load Time: " + TimeUtils.toMilliseconds(ClassPrototypeGeneratorManager.getTotalLoadTime()));
            PandaFramework.getLogger().debug("Total Handle Time: " + TimeUtils.toMilliseconds(pipelineRegistry.getTotalHandleTime()));
            PandaFramework.getLogger().debug("Loaded prototypes: " + modulePath.getAmountOfPrototypes());
        }
        return this.interpretation.execute(() -> BenchmarkUtils.execute("Generation#execute", () -> generation.execute(baseData))).execute(() -> application);
    }
}

