/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.number;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.module.PrimitivePrototypeLiquid;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.ParticularParser;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.architecture.value.PandaValue;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.parser.implementation.general.number.NumberType;
import org.panda_lang.panda.framework.language.parser.implementation.general.number.NumberUtils;

public class NumberExpressionParser
implements ParticularParser<Value> {
    @Override
    @Nullable
    public Value parse(ParserData data, TokenizedSource source) {
        PandaValue value;
        Number parsedNumber;
        NumberType numberType;
        String number;
        if (!NumberUtils.isNumeric(source)) {
            return null;
        }
        String unknownNumber = source.asString();
        char numberTypeDefinitionCharacter = unknownNumber.charAt(unknownNumber.length() - 1);
        NumberType numberTypeDefinition = NumberType.of(numberTypeDefinitionCharacter);
        String string = number = numberTypeDefinition == null ? unknownNumber : unknownNumber.substring(0, unknownNumber.length() - 1);
        if (!Character.isDigit(numberTypeDefinitionCharacter) && numberTypeDefinition == null) {
            throw new PandaParserException("Unknown number type " + numberTypeDefinitionCharacter);
        }
        if (number.contains(".")) {
            numberType = NumberType.DOUBLE;
            parsedNumber = Double.parseDouble(number);
        } else if (number.contains("x")) {
            numberType = NumberType.INT;
            parsedNumber = Long.parseLong(number.substring(2), 16);
        } else {
            numberType = NumberType.INT;
            parsedNumber = Long.parseLong(number);
        }
        if (numberTypeDefinition != null) {
            numberType = numberTypeDefinition;
        }
        ModulePath registry = data.getComponent(PandaComponents.MODULE_REGISTRY);
        switch (numberType) {
            case BYTE: {
                value = new PandaValue(PrimitivePrototypeLiquid.BYTE, parsedNumber.byteValue());
                break;
            }
            case SHORT: {
                value = new PandaValue(PrimitivePrototypeLiquid.SHORT, parsedNumber.shortValue());
                break;
            }
            case INT: {
                value = new PandaValue(PrimitivePrototypeLiquid.INT, parsedNumber.intValue());
                break;
            }
            case LONG: {
                value = new PandaValue(PrimitivePrototypeLiquid.LONG, parsedNumber.longValue());
                break;
            }
            case FLOAT: {
                value = new PandaValue(PrimitivePrototypeLiquid.FLOAT, Float.valueOf(parsedNumber.floatValue()));
                break;
            }
            case DOUBLE: {
                value = new PandaValue(PrimitivePrototypeLiquid.DOUBLE, parsedNumber.doubleValue());
                break;
            }
            default: {
                throw new PandaParserException("Unknown number type: " + (Object)((Object)numberType));
            }
        }
        return value;
    }
}

