/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.overall.module;

import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.Script;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.statement.ModuleStatement;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGeneration;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationType;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactorHollows;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.parser.implementation.overall.module.ModuleParserHandler;

@ParserRegistration(target={"overall"}, parserClass=ModuleParser.class, handlerClass=ModuleParserHandler.class)
public class ModuleParser
implements UnifiedParser {
    private static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "module +** ;").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGeneration generation = data.getComponent(UniversalComponents.GENERATION);
        generation.getLayer(CasualParserGenerationType.HIGHER).delegateImmediately(new GroupDeclarationCasualParserCallback(), data).delegateAfter(new GroupAfterCasualParserCallback(), data.fork());
    }

    private static class GroupAfterCasualParserCallback
    implements CasualParserGenerationCallback {
        private GroupAfterCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            Script script = delegatedData.getComponent(UniversalComponents.SCRIPT);
            List<ModuleStatement> moduleStatements = script.select(ModuleStatement.class);
            if (moduleStatements.size() == 0) {
                return;
            }
            if (moduleStatements.size() > 1) {
                throw new PandaParserException("Script contains more than one declaration of the group");
            }
        }
    }

    private static class GroupDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private GroupDeclarationCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            AbyssRedactorHollows hollows = AbyssPatternAssistant.extract(PATTERN, delegatedData);
            TokenizedSource hollow = hollows.getGap(0);
            StringBuilder groupNameBuilder = new StringBuilder();
            for (TokenRepresentation representation : hollow.getTokensRepresentations()) {
                Token token = representation.getToken();
                groupNameBuilder.append(token.getTokenValue());
            }
            String groupName = groupNameBuilder.toString();
            ModulePath modulePath = delegatedData.getComponent(PandaComponents.MODULE_REGISTRY);
            if (!modulePath.hasModule(groupName)) {
                modulePath.create(groupName);
            }
            Module module = modulePath.get(groupName);
            PandaScript script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
            script.setModule(module);
            ModuleLoader moduleLoader = script.getModuleLoader();
            moduleLoader.include(module);
            ModuleStatement moduleStatement = new ModuleStatement(module);
            script.getStatements().add(moduleStatement);
        }
    }
}

