/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.statement.invoker;

import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.prototype.method.MethodInvoker;
import org.panda_lang.panda.framework.design.architecture.prototype.method.PrototypeMethod;
import org.panda_lang.panda.framework.design.architecture.statement.Container;
import org.panda_lang.panda.framework.design.architecture.statement.StatementCell;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.CasualParserGenerationAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.general.argument.ArgumentParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionUtils;
import org.panda_lang.panda.framework.language.parser.implementation.statement.invoker.MethodInvokerParserHandler;
import org.panda_lang.panda.language.runtime.expression.Expression;

@ParserRegistration(target={"statement"}, parserClass=MethodInvokerParser.class, handlerClass=MethodInvokerParserHandler.class, priority=1)
public class MethodInvokerParser
implements UnifiedParser {
    public static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** . +** ( +* )").lastIndexAlgorithm(true).build();

    @Override
    public void parse(ParserData data) {
        CasualParserGenerationAssistant.delegateImmediately(data, new MethodInvokerDeclarationCasualParserCallback());
    }

    private static class MethodInvokerCasualParserCallback
    implements CasualParserGenerationCallback {
        private final StatementCell cell;
        private final AbyssRedactor redactor;

        private MethodInvokerCasualParserCallback(StatementCell cell, AbyssRedactor redactor) {
            this.cell = cell;
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            TokenizedSource instanceSource = this.redactor.get("instance");
            TokenizedSource methodSource = this.redactor.get("method-name");
            TokenizedSource argumentsSource = this.redactor.get("arguments");
            PandaScript script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
            ModuleLoader registry = script.getModuleLoader();
            String surmiseClassName = instanceSource.asString();
            ClassPrototype prototype = registry.forClass(surmiseClassName);
            String methodName = methodSource.asString();
            Expression instance = null;
            if (prototype == null) {
                ExpressionParser expressionParser = new ExpressionParser();
                instance = expressionParser.parse(delegatedData, instanceSource);
                prototype = instance.getReturnType();
            }
            ArgumentParser argumentParser = new ArgumentParser();
            Expression[] arguments = argumentParser.parse(delegatedData, argumentsSource);
            ClassPrototype[] parameterTypes = ExpressionUtils.toTypes(arguments);
            PrototypeMethod prototypeMethod = prototype.getMethods().getMethod(methodName, parameterTypes);
            if (prototypeMethod == null) {
                PrototypeField field = prototype.getFields().getField(methodName);
                if (field == null) {
                    throw new PandaParserException("Method " + methodName + " not found in class " + prototype.getClassName() + " at line " + TokenUtils.getLine(instanceSource));
                }
                throw new PandaParserException("Not implemented");
            }
            MethodInvoker invoker = new MethodInvoker(prototypeMethod, instance, arguments);
            this.cell.setStatement(invoker);
        }
    }

    private static class MethodInvokerDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private MethodInvokerDeclarationCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, delegatedData, "instance", "method-name", "arguments");
            Container container = delegatedData.getComponent(PandaComponents.CONTAINER);
            StatementCell cell = container.reserveCell();
            nextLayer.delegate(new MethodInvokerCasualParserCallback(cell, redactor), delegatedData);
        }
    }
}

