/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.statement.scope.branching;

import org.panda_lang.panda.framework.design.architecture.dynamic.branching.Return;
import org.panda_lang.panda.framework.design.architecture.statement.Container;
import org.panda_lang.panda.framework.design.architecture.statement.StatementCell;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.architecture.statement.PandaStatementData;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.CasualParserGenerationAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.statement.scope.branching.ReturnParserHandler;
import org.panda_lang.panda.language.runtime.expression.Expression;

@ParserRegistration(target={"statement"}, parserClass=ReturnParser.class, handlerClass=ReturnParserHandler.class)
public class ReturnParser
implements UnifiedParser {
    private static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "return +*").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGenerationAssistant.delegateImmediately(data, new ReturnCasualParserCallback());
    }

    private static class ReturnExpressionCasualParserCallback
    implements CasualParserGenerationCallback {
        private final StatementCell cell;
        private final AbyssRedactor redactor;

        public ReturnExpressionCasualParserCallback(StatementCell cell, AbyssRedactor redactor) {
            this.cell = cell;
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            TokenizedSource expressionSource = this.redactor.get("return-expression");
            ExpressionParser expressionParser = new ExpressionParser();
            Expression expression = expressionParser.parse(delegatedData, expressionSource);
            Return returnStatement = new Return(expression);
            this.cell.setStatement(returnStatement);
            PandaStatementData statementData = new PandaStatementData(expressionSource.getFirst().getLine());
            returnStatement.setStatementData(statementData);
        }
    }

    private static class ReturnCasualParserCallback
    implements CasualParserGenerationCallback {
        private ReturnCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            SourceStream stream = delegatedData.getComponent(UniversalComponents.SOURCE_STREAM);
            Container container = delegatedData.getComponent(PandaComponents.CONTAINER);
            if (stream.getUnreadLength() == 1) {
                Return returnStatement = new Return(null);
                container.addStatement(returnStatement);
                TokenRepresentation returnToken = stream.read();
                PandaStatementData statementData = new PandaStatementData(returnToken.getLine());
                returnStatement.setStatementData(statementData);
                return;
            }
            StatementCell cell = container.reserveCell();
            AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, delegatedData, "return-expression");
            nextLayer.delegate(new ReturnExpressionCasualParserCallback(cell, redactor), delegatedData);
        }
    }
}

