/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.runtime;

import java.util.Collection;
import org.panda_lang.panda.framework.design.architecture.dynamic.Executable;
import org.panda_lang.panda.framework.design.architecture.dynamic.ScopeInstance;
import org.panda_lang.panda.framework.design.architecture.dynamic.StandaloneExecutable;
import org.panda_lang.panda.framework.design.architecture.statement.StatementCell;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.runtime.PandaExecutableProcess;
import org.panda_lang.panda.framework.language.runtime.flow.PandaControlFlow;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.flow.ControlFlow;
import org.panda_lang.panda.language.runtime.flow.ControlFlowCaller;

public class PandaExecutableBranch
implements ExecutableBranch {
    private final PandaExecutableProcess process;
    private final ScopeInstance currentScope;
    private PandaControlFlow currentFlow;
    private Value returnedValue;
    private boolean interrupted;
    private Value instance;

    public PandaExecutableBranch(PandaExecutableProcess process, ScopeInstance currentScope) {
        this.process = process;
        this.currentScope = currentScope;
    }

    @Override
    public void call() {
        if (this.isInterrupted()) {
            return;
        }
        this.currentScope.execute(this);
    }

    @Override
    public void call(Collection<StatementCell> cells) {
        for (StatementCell statementCell : cells) {
            if (this.isInterrupted()) {
                return;
            }
            if (!statementCell.isExecutable()) continue;
            Executable executable = (Executable)((Object)statementCell.getStatement());
            this.call(executable);
        }
    }

    @Override
    public ControlFlow callFlow(Collection<StatementCell> cells, ControlFlowCaller caller) {
        if (this.isInterrupted()) {
            return this.currentFlow;
        }
        PandaControlFlow parentFlow = this.currentFlow;
        this.currentFlow = new PandaControlFlow(this, cells, caller);
        this.currentFlow.execute(this);
        this.currentFlow = parentFlow;
        return this.currentFlow;
    }

    @Override
    public ExecutableBranch call(Executable executable) {
        if (this.isInterrupted()) {
            return this;
        }
        if (executable instanceof StandaloneExecutable) {
            return this.callStandalone(executable);
        }
        executable.execute(this);
        return this;
    }

    @Override
    public ExecutableBranch callStandalone(Executable executable) {
        boolean standaloneScope = executable instanceof ScopeInstance;
        ScopeInstance scope = standaloneScope ? (ScopeInstance)executable : this.currentScope;
        PandaExecutableBranch branch = new PandaExecutableBranch(this.process, scope);
        branch.instance(this.instance);
        if (this.isInterrupted()) {
            return branch;
        }
        if (standaloneScope) {
            branch.call();
        } else {
            executable.execute(branch);
        }
        return branch;
    }

    @Override
    public ExecutableBranch duplicate() {
        PandaExecutableBranch duplicatedBranch = new PandaExecutableBranch(this.process, this.currentScope);
        duplicatedBranch.currentFlow = this.currentFlow;
        duplicatedBranch.instance = this.instance;
        duplicatedBranch.returnedValue = this.returnedValue;
        duplicatedBranch.interrupted = this.interrupted;
        return duplicatedBranch;
    }

    @Override
    public void instance(Value instance) {
        this.instance = instance;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void returnValue(Value value) {
        this.returnedValue = value;
        this.interrupt();
    }

    @Override
    public void setReturnValue(Value value) {
        this.returnedValue = value;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public Value getReturnedValue() {
        return this.returnedValue;
    }

    @Override
    public ControlFlow getCurrentControlFlow() {
        return this.currentFlow;
    }

    @Override
    public ScopeInstance getCurrentScope() {
        return this.currentScope;
    }

    @Override
    public Value getInstance() {
        return this.instance;
    }
}

