/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.runtime.expression;

import java.security.InvalidParameterException;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;
import org.panda_lang.panda.language.runtime.expression.ExpressionCallback;
import org.panda_lang.panda.language.runtime.expression.ExpressionType;

public class PandaExpression
implements Expression {
    private final ExpressionType type;
    private final ClassPrototype returnType;
    private final ExpressionCallback callback;
    private final Value value;

    public PandaExpression(Value value) {
        this(ExpressionType.KNOWN, value.getType(), null, value);
    }

    public PandaExpression(ClassPrototype returnType, ExpressionCallback callback) {
        this(ExpressionType.UNKNOWN, returnType, callback, null);
    }

    private PandaExpression(ExpressionType type, ClassPrototype returnType, ExpressionCallback callback, Value value) {
        if (type == null) {
            throw new InvalidParameterException("ExpressionType cannot be null");
        }
        if (callback == null && value == null) {
            throw new InvalidParameterException("Callback and Value cannot be null at the same time");
        }
        this.type = type;
        this.returnType = returnType;
        this.callback = callback;
        this.value = value;
    }

    @Override
    public Value getExpressionValue(ExecutableBranch branch) {
        if (this.type == ExpressionType.UNKNOWN || this.type == ExpressionType.BOTH) {
            return this.callback.call(this, branch);
        }
        return this.value;
    }

    @Override
    public ClassPrototype getReturnType() {
        return this.returnType;
    }

    @Override
    public ExpressionType getType() {
        return this.type;
    }

    public String toString() {
        String s = this.type.name() + ":" + this.returnType.getClassName();
        return ExpressionType.KNOWN == this.type ? s + ":" + this.value.getValue() : s;
    }
}

