/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.runtime.flow;

import java.util.Collection;
import org.panda_lang.panda.framework.design.architecture.dynamic.Executable;
import org.panda_lang.panda.framework.design.architecture.statement.StatementCell;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.flow.ControlFlow;
import org.panda_lang.panda.language.runtime.flow.ControlFlowCaller;

public class PandaControlFlow
implements Executable,
ControlFlow {
    private final ExecutableBranch branch;
    private final Collection<StatementCell> cells;
    private final ControlFlowCaller caller;
    private boolean skipped;
    private boolean escaped;

    public PandaControlFlow(ExecutableBranch branch, Collection<StatementCell> cells, ControlFlowCaller caller) {
        this.branch = branch;
        this.cells = cells;
        this.caller = caller;
    }

    @Override
    public void execute(ExecutableBranch branch) {
        this.caller.call(branch, this);
    }

    @Override
    public void call() {
        this.reset();
        for (StatementCell statementCell : this.cells) {
            if (this.branch.isInterrupted() || this.isEscaped() || this.isSkipped()) break;
            if (!statementCell.isExecutable()) continue;
            this.branch.call((Executable)((Object)statementCell.getStatement()));
        }
    }

    @Override
    public void reset() {
        this.skipped = false;
        this.escaped = false;
    }

    @Override
    public void skip() {
        this.skipped = true;
    }

    @Override
    public void escape() {
        this.escaped = true;
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public boolean isEscaped() {
        return this.escaped;
    }
}

