/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.ClassFile;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsDisposable;
import org.panda_lang.panda.utilities.commons.collection.Multimap;

public class AnnotationScannerStore
implements AnnotationsDisposable {
    private final Multimap<String, String> store = new Multimap(new HashMap(), HashSet::new);
    private final Map<String, ClassFile> classFiles = new HashMap<String, ClassFile>();

    public void addInheritors(String type, String inheritor) {
        this.store.put(type, inheritor);
    }

    public void addClassFile(ClassFile classFile) {
        this.classFiles.put(classFile.getName(), classFile);
    }

    public void addClassFiles(Collection<ClassFile> classFiles) {
        for (ClassFile classFile : classFiles) {
            this.addClassFile(classFile);
        }
    }

    public Set<String> getInheritorsOf(String type) {
        HashSet<String> inheritors = new HashSet<String>();
        Collection<String> directInheritors = this.store.get(type);
        if (directInheritors == null) {
            return inheritors;
        }
        inheritors.addAll(directInheritors);
        for (String directInheritor : directInheritors) {
            Set<String> indirectInheritors = this.getInheritorsOf(directInheritor);
            inheritors.addAll(indirectInheritors);
        }
        return inheritors;
    }

    @Override
    public void dispose() {
        this.store.clear();
        this.classFiles.clear();
    }

    @Nullable
    public ClassFile getCachedClassFile(String type) {
        return this.classFiles.get(type);
    }

    public int getAmountOfCachedClassFiles() {
        return this.classFiles.size();
    }

    public Collection<? extends ClassFile> getCachedClassFiles() {
        return this.classFiles.values();
    }
}

