/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationScannerStore;
import org.panda_lang.panda.utilities.annotations.AnnotationsDisposable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScanner;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerFile;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerProcessBuilder;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerSelector;
import org.panda_lang.panda.utilities.annotations.adapter.MetadataAdapter;
import org.panda_lang.panda.utilities.annotations.monads.AnnotationsFilter;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;
import org.panda_lang.panda.utilities.commons.objects.TimeUtils;

public class AnnotationsScannerProcess
implements AnnotationsDisposable {
    private final AnnotationsScanner scanner;
    private final AnnotationScannerStore store;
    private final List<AnnotationsFilter<URL>> urlFilters;
    private final List<AnnotationsFilter<AnnotationsScannerFile>> fileFilters;
    private final List<AnnotationsFilter<ClassFile>> classFileFilters;

    AnnotationsScannerProcess(AnnotationsScannerProcessBuilder builder) {
        this.scanner = builder.scanner;
        this.store = builder.store;
        this.urlFilters = builder.urlFilters;
        this.fileFilters = builder.fileFilters;
        this.classFileFilters = builder.classFileFilters;
    }

    protected AnnotationsScannerProcess fetch() {
        long uptime = System.nanoTime();
        for (AnnotationsScannerResource<?> resource : this.scanner.getConfiguration().getResources()) {
            Set<ClassFile> classFiles = this.scanResource(resource);
            this.store.addClassFiles(classFiles);
        }
        this.scanner.getLogger().debug("Fetched class files: " + this.store.getAmountOfCachedClassFiles() + " in " + TimeUtils.toMilliseconds(System.nanoTime() - uptime));
        return this;
    }

    public AnnotationsScannerSelector createSelector() {
        return new AnnotationsScannerSelector(this, this.store);
    }

    private Set<ClassFile> scanResource(AnnotationsScannerResource<?> resource) {
        HashSet<ClassFile> classFiles = new HashSet<ClassFile>();
        for (AnnotationsFilter<URL> urlFilter : this.urlFilters) {
            if (urlFilter.check(this.getMetadataAdapter(), resource.getLocation())) continue;
            return classFiles;
        }
        for (AnnotationsScannerFile annotationsScannerFile : resource) {
            ClassFile classFile;
            if (annotationsScannerFile == null || !annotationsScannerFile.getOriginalPath().endsWith(".class") || (classFile = this.scanFile(annotationsScannerFile)) == null) continue;
            classFiles.add(classFile);
        }
        return classFiles;
    }

    @Nullable
    private ClassFile scanFile(AnnotationsScannerFile file) {
        ClassFile pseudoClass;
        MetadataAdapter<ClassFile, FieldInfo, MethodInfo> metadataAdapter = this.getMetadataAdapter();
        for (AnnotationsFilter<AnnotationsScannerFile> fileFilter : this.fileFilters) {
            if (fileFilter.check(metadataAdapter, file)) continue;
            return null;
        }
        try {
            pseudoClass = metadataAdapter.getOfCreateClassObject(this.scanner, file);
        }
        catch (Exception e) {
            return null;
        }
        if (!StringUtils.isEmpty(pseudoClass.getSuperclass())) {
            this.store.addInheritors(pseudoClass.getSuperclass(), pseudoClass.getName());
        }
        if (pseudoClass.getInterfaces() != null) {
            for (String anInterface : pseudoClass.getInterfaces()) {
                this.store.addInheritors(anInterface, pseudoClass.getName());
            }
        }
        for (AnnotationsFilter annotationsFilter : this.classFileFilters) {
            if (annotationsFilter.check(metadataAdapter, pseudoClass)) continue;
            return null;
        }
        return pseudoClass;
    }

    @Override
    public void dispose() {
        this.store.dispose();
    }

    public MetadataAdapter<ClassFile, FieldInfo, MethodInfo> getMetadataAdapter() {
        return this.scanner.getConfiguration().getMetadataAdapter();
    }

    protected AnnotationsScanner getScanner() {
        return this.scanner;
    }
}

