/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScanner;

public class AnnotationsScannerUtils {
    protected static final String[] PANDA_PACKAGES = new String[]{"META-INF", "java", "com.sun", "sun", "jdk", "javax", "oracle", "com.oracle", "netscape", "org.apache", "com.google", "org.slf4j", "org.junit", "junit", "org.jetbrains", "org.intellij", "org.opentest4j"};
    static List<String> primitiveNames = Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
    static List<String> primitiveDescriptors = Arrays.asList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
    static List<Class> primitiveTypes = Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);

    public static String toClassPath(String path) {
        return path.replace("/", ".").replace(".class", "");
    }

    static Set<Class<?>> forNames(AnnotationsScanner scanner, Collection<String> types) {
        HashSet classes = new HashSet();
        for (String type : types) {
            Class<?> clazz = AnnotationsScannerUtils.forName(scanner, type, new ClassLoader[0]);
            if (type == null) continue;
            classes.add(clazz);
        }
        return classes;
    }

    @Nullable
    static Class<?> forName(AnnotationsScanner scanner, String typeName, ClassLoader ... classLoaders) {
        String type;
        if (primitiveNames.contains(typeName)) {
            return primitiveTypes.get(primitiveNames.indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = primitiveNames.contains(type) ? primitiveDescriptors.get(primitiveNames.indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        for (ClassLoader classLoader : scanner.getConfiguration().getClassLoaders()) {
            if (type.contains("[")) {
                try {
                    return Class.forName(type, false, classLoader);
                }
                catch (Throwable e) {
                    scanner.getLogger().exception(e);
                }
            }
            try {
                return classLoader.loadClass(type);
            }
            catch (Throwable e) {
                scanner.getLogger().exception(e);
            }
        }
        scanner.getLogger().warn("Could not get type for name " + typeName + " from any class loader");
        return null;
    }
}

