/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.arrays;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class ArrayDistributor<T>
implements Iterator<T>,
Iterable<T> {
    private final T[] array;
    private int index;

    public ArrayDistributor(T[] array) {
        this.array = (Object[])array.clone();
        this.index = -1;
    }

    public ArrayDistributor(Collection<T> collection, Class<T> type) {
        this(collection.toArray((Object[])Array.newInstance(type, collection.size())));
    }

    public void reset() {
        this.index = -1;
    }

    public void reverse() {
        T[] copy = Arrays.copyOf(this.array, this.array.length);
        int i = 0;
        int j = this.array.length - 1;
        while (i < this.array.length) {
            this.array[i] = copy[j];
            ++i;
            --j;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Nullable
    public T previous() {
        if (this.index - 1 < this.array.length) {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
            return this.array[this.index];
        }
        return null;
    }

    @Nullable
    public T current() {
        return this.index < this.array.length && this.index > -1 ? (T)this.array[this.index] : null;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.array.length;
    }

    @Override
    @Nullable
    public T next() {
        if (this.index + 1 < this.array.length) {
            return this.array[++this.index];
        }
        throw new NoSuchElementException();
    }

    @Nullable
    public T further() {
        if (this.index + 1 < this.array.length) {
            return this.array[this.index + 1];
        }
        return null;
    }

    @Nullable
    public T future() {
        if (this.index + 2 < this.array.length) {
            return this.array[this.index + 2];
        }
        return null;
    }

    @Nullable
    public T getPrevious(int t) {
        int i = this.index - t;
        return i > -1 && i < this.array.length ? (T)this.array[i] : null;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Nullable
    public T get(int index) {
        return index > -1 && index < this.array.length ? (T)this.array[index] : null;
    }

    @Nullable
    public T getPrevious() {
        int i = this.index - 1;
        return i > -1 && i - 1 < this.array.length ? (T)this.array[i] : null;
    }

    @Nullable
    public T getLast() {
        return this.array[this.array.length - 1];
    }

    @Nullable
    public T getNext() {
        return this.index + 1 < this.array.length ? this.array[this.index + 1] : this.getLast();
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.array.length;
    }
}

