/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.collection;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ReverseIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final List<T> list;
    private int index;

    public ReverseIterator(List<T> list) {
        this.list = list;
        this.index = list.size() - 1;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.index > 0;
    }

    @Override
    @Nullable
    public T next() {
        return this.index - 1 > -1 ? (T)this.list.get(this.index--) : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

