/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    public static Collection<File> findFilesByExtension(String directory, String extension) {
        return FileUtils.findFilesByExtension(new File(directory), extension);
    }

    public static Collection<File> findFilesByExtension(File directory, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.findFilesByExtension(directory, extension, files);
        return files;
    }

    private static void findFilesByExtension(File directory, String extension, Collection<File> files) {
        if (directory.isFile()) {
            return;
        }
        File[] filesList = directory.listFiles();
        if (filesList == null) {
            return;
        }
        for (File file : filesList) {
            if (file.isDirectory()) {
                FileUtils.findFilesByExtension(file, extension, files);
                continue;
            }
            if (!file.getName().endsWith(extension)) continue;
            files.add(file);
        }
    }

    public static void overrideFile(File file, String content) {
        try {
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't write contents to file: " + file, e);
        }
    }

    public static String getContentOfFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read contents of file: " + file, e);
        }
    }

    @Nullable
    public static String[] getContentAsLines(File file) {
        if (!file.exists()) {
            return new String[0];
        }
        try {
            List<String> list = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            String[] result = new String[list.size()];
            return list.toArray(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileName(File file) {
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(".");
        if (pos == -1) {
            return fileName;
        }
        return fileName.substring(0, pos);
    }

    public static File[] toFiles(String ... paths) {
        File[] files = new File[paths.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(paths[i]);
        }
        return files;
    }

    public static boolean delete(File file) {
        File[] files;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File c : files) {
                FileUtils.delete(c);
            }
        }
        return file.delete();
    }

    public static boolean isIn(File[] files, String fileName) {
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }
}

