/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.pattern.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.panda_lang.panda.utilities.commons.pattern.PatternMatcher;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowPatternBuilder;
import org.panda_lang.panda.utilities.commons.pattern.text.TextHollowSymbol;

public class TextHollowPattern
implements PatternMatcher {
    private final List<TextHollowSymbol> hollowSymbols;
    private final List<String> hollows;

    protected TextHollowPattern(List<TextHollowSymbol> hollowSymbols) {
        this.hollowSymbols = hollowSymbols;
        this.hollows = new ArrayList<String>();
    }

    @Override
    public boolean match(String expression) {
        this.hollows.clear();
        block0: for (int f = 0; f < this.hollowSymbols.size(); ++f) {
            TextHollowSymbol hollowSymbol = this.hollowSymbols.get(f);
            if (hollowSymbol.isBasis()) {
                for (String variant : hollowSymbol.getVariants()) {
                    String part;
                    if (!variant.equals(part = this.getPart(expression, 0, variant.length()))) continue;
                    expression = expression.substring(variant.length(), expression.length());
                    continue block0;
                }
                return false;
            }
            if (!hollowSymbol.isHollow()) continue;
            boolean inRange = this.hollowSymbols.size() > hollowSymbol.getIndex() + 1;
            TextHollowSymbol nextHollowSymbol = inRange ? this.hollowSymbols.get(hollowSymbol.getIndex() + 1) : hollowSymbol;
            Iterator<String> iterator = nextHollowSymbol.getVariants().iterator();
            if (iterator.hasNext()) {
                String variant = iterator.next();
                int partIndex = expression.indexOf(variant);
                if (partIndex < 0) {
                    return false;
                }
                String hollow = expression.substring(0, partIndex);
                expression = expression.substring(partIndex, expression.length());
                this.hollows.add(hollow);
                continue;
            }
            this.hollows.add(expression);
            expression = "";
        }
        return expression.length() < 1;
    }

    public void clear() {
        this.hollows.clear();
    }

    public List<String> cloneHollows() {
        return new ArrayList<String>(this.hollows);
    }

    public String getPart(String string, int beginIndex, int endIndex) {
        return string.length() >= endIndex ? string.substring(beginIndex, endIndex) : string.substring(beginIndex, string.length());
    }

    public List<String> getHollows() {
        return this.hollows;
    }

    public List<TextHollowSymbol> getHollowSymbols() {
        return this.hollowSymbols;
    }

    public String toString() {
        return this.hollowSymbols.toString();
    }

    public static TextHollowPatternBuilder builder() {
        return new TextHollowPatternBuilder();
    }
}

