/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.commons.redact;

import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.commons.arrays.CharArrayDistributor;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;

public class BracketContentReader {
    protected static final char[] OPENING_SEQUENCE = "({[<\"".toCharArray();
    protected static final char[] CLOSING_SEQUENCE = ")}]>\"".toCharArray();
    private final CharArrayDistributor distributor;
    private char[] openingSequence = OPENING_SEQUENCE;
    private char[] closingSequence = CLOSING_SEQUENCE;

    public BracketContentReader(CharArrayDistributor distributor) {
        this.distributor = distributor;
    }

    public BracketContentReader(String expression) {
        this(new CharArrayDistributor(expression));
    }

    @Nullable
    public String readCurrent() {
        this.distributor.previous();
        return this.read();
    }

    @Nullable
    public String read() {
        char current;
        Stack<Character> sequences = new Stack<Character>();
        char leftType = this.distributor.next();
        if (!CharacterUtils.belongsTo(leftType, this.openingSequence)) {
            throw new RuntimeException("Unknown bracket type: " + leftType);
        }
        StringBuilder content = new StringBuilder();
        char rightType = this.closingSequence[CharacterUtils.getIndex(this.openingSequence, leftType)];
        while (this.distributor.hasNext() && ((current = this.distributor.next()) != rightType || sequences.size() != 0)) {
            BracketContentReader.verifySequences(sequences, this.openingSequence, this.closingSequence, current);
            content.append(current);
        }
        if (sequences.size() > 0) {
            return null;
        }
        return content.toString();
    }

    protected static void verifySequences(Stack<Character> sequences, char[] openingSequence, char[] closingSequence, char current) {
        if (sequences.size() > 0 && CharacterUtils.belongsTo(current, closingSequence)) {
            Character leftCurrent = Character.valueOf(openingSequence[CharacterUtils.getIndex(closingSequence, current)]);
            if (sequences.peek() != leftCurrent) {
                return;
            }
            sequences.pop();
            return;
        }
        if (CharacterUtils.belongsTo(current, openingSequence)) {
            sequences.push(Character.valueOf(current));
        }
    }

    public void setOpeningSequence(char[] openingSequence) {
        this.openingSequence = openingSequence;
    }

    public void setClosingSequence(char[] closingSequence) {
        this.closingSequence = closingSequence;
    }
}

